/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2;

import com.atlassian.mail.HtmlToTextConverter;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.MutableRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.components.RendererComponent;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Category;

public class V2Renderer
implements MutableRenderer {
    public static final Category log = Category.getInstance(V2Renderer.class);
    public static final String RENDERER_TYPE = "atlassian-wiki-renderer";
    private RendererComponent[] components = new RendererComponent[0];

    public V2Renderer() {
    }

    public V2Renderer(List components) {
        this.components = components.toArray(new RendererComponent[components.size()]);
    }

    public void setComponents(List components) {
        this.components = components.toArray(new RendererComponent[components.size()]);
    }

    public String render(String wiki, RenderContext renderContext) {
        try {
            if (!TextUtils.stringSet((String)wiki)) {
                return "";
            }
            if (renderContext.getRenderMode().renderNothing()) {
                return wiki;
            }
            String renderedWiki = wiki;
            for (int i = 0; i < this.components.length; ++i) {
                RendererComponent rendererComponent = this.components[i];
                RenderMode renderMode = renderContext.getRenderMode();
                if (!rendererComponent.shouldRender(renderMode)) continue;
                renderedWiki = rendererComponent.render(renderedWiki, renderContext);
            }
            return renderedWiki;
        }
        catch (Throwable t) {
            log.error((Object)("Unable to render content due to system error: " + t.getMessage()), t);
            return RenderUtils.error("Unable to render content due to system error: " + t.getMessage());
        }
    }

    public String renderAsText(String originalContent, RenderContext context) {
        try {
            return new HtmlToTextConverter().convert(this.render(originalContent, context));
        }
        catch (IOException e) {
            return originalContent;
        }
    }

    public String getRendererType() {
        return RENDERER_TYPE;
    }
}

