/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.wysiwyg;

import com.atlassian.renderer.Icon;
import com.atlassian.renderer.IconManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.macro.Macro;
import com.atlassian.renderer.v2.macro.MacroManager;
import com.atlassian.renderer.v2.macro.ResourceAwareMacroDecorator;
import com.atlassian.renderer.wysiwyg.ListContext;
import com.atlassian.renderer.wysiwyg.Styles;
import com.atlassian.renderer.wysiwyg.WysiwygConverter;
import com.atlassian.renderer.wysiwyg.WysiwygLinkHelper;
import com.atlassian.renderer.wysiwyg.WysiwygNodeConverter;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.html.dom.HTMLDocumentImpl;
import org.apache.log4j.Category;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.cyberneko.html.filters.Writer;
import org.cyberneko.html.parsers.DOMFragmentParser;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultWysiwygConverter
implements WysiwygConverter {
    public static final String TEXT_SEPERATOR = "TEXTSEP";
    private static Category log = Category.getInstance((Class)DefaultWysiwygConverter.class);
    private MacroManager macroManager;
    private static final Separation[] separators = new Separation[]{new Separation("list", "heading", "\n", null), new Separation("table", "table", "\n\n", null), new Separation("table", "div", "\n", null), new Separation("table", "a", "\n", null), new Separation("table", "p", "\n", null), new Separation("text", "table", "\n", null), new Separation("list", "p", "\n\n", null), new Separation("blockquote", "p", "\n", null), new Separation("p", "list", "\n", "\n"), new Separation("p", "table", "\n", null), new Separation("p", "text", "\n\n", null), new Separation("heading", "table", "\n", null), new Separation("heading", "div", "\n", "", ""), new Separation("heading", "span", "\n", null), new Separation("heading", "text", "\n", null), new Separation("heading", "heading", "\n", null), new Separation("heading", "p", "\n", null), new Separation("p", "p", "\n\n", "\\\\\n", "\\\\\n"), new Separation("tr", "tr", "\n", "\n"), new Separation("list", "list", "\n\n", null), new Separation("heading", "list", "\n", null), new Separation("text", "list", "\n", "\n"), new Separation("a", "list", "\n", "\n"), new Separation("br", "list", "", ""), new Separation("div", "list", "\n", "\n"), new Separation("div", "table", "\n", "\n"), new Separation("div", "imagelink", "\n", "\n"), new Separation("div", "text", "\n", "\n"), new Separation("div", "p", "\n", null), new Separation("list", "div", "\n\n", null), new Separation("list", "a", "\n\n", null), new Separation("list", "text", "\n\n", "\n"), new Separation("list", "table", "\n\n", null), new Separation("list", "br", "\n", null), new Separation("forcedNewline", "list", "\n", "\n"), new Separation("forcedNewline", "li", "", ""), new Separation("forcedNewline", "text", "\n", "\n"), new Separation("forcedNewline", "forcedNewline", "\n", "\n"), new Separation("forcedNewline", "a", "\n", "\n"), new Separation("forcedNewline", "div", "\n", "\n"), new Separation("text", "forcedNewline", "\n", "TEXTSEP"), new Separation("table", "forcedNewline", "\n", "TEXTSEP"), new Separation("table", "text", "\n", null), new Separation("table", "list", "\n", null), new Separation("pre", "text", "\n", null), new Separation("pre", "pre", "\n", null), new Separation("li", "li", "\n", "\n"), new Separation("li", "list", "\n", "\n"), new Separation("list", "li", "\n", "\n"), new Separation("span", "heading", "\n", "", ""), new Separation("text", "heading", "\n", "", ""), new Separation("p", "heading", "\n", "", ""), new Separation("p", "div", "\n", "", "\n"), new Separation("text", "div", "\n", "\n", "\n"), new Separation("text", "p", "\n", null, null), new Separation("span", "div", "\n", "\n", "\n"), new Separation("span", "p", "\n", null, null), new Separation("table", "heading", "\n", "", ""), new Separation("div", "heading", "\n", "", ""), new Separation("div", "div", "\n", "", "\n"), new Separation("hr", "imagelink", "\n", "\n", "\n"), new Separation("hr", "div", "\n", "\n", "\n"), new Separation("hr", "list", "\n", "\n", "\n"), new Separation("hr", "table", "\n", "\n", "\n"), new Separation("hr", "p", "\n", null, null), new Separation("hr", "text", "\n", null, null), new Separation("font", "list", "\n", "\n", "\n"), new Separation("emoticon", "text", " ", "\n")};
    private Map sepMap = null;
    protected static boolean debug = false;
    private IconManager iconManager;
    protected WikiStyleRenderer renderer;
    protected HashSet macrosToIgnore = new HashSet();
    private static String[] escapedCharactersRegex = new String[]{"(\\\\)?\\[", "(\\\\)?\\]", "([^\\s])([\\*\\-\\+\\^~_](?:[\\s]|$))", "((?:^|[\\s]))([\\*\\-\\+\\^~_][^\\s])", "(\\\\)?!", "(\\\\)?\\|", "(^\\s*)([\\*\\#\\-])"};
    private static String[] escapedCharactersReplacement = new String[]{"\\\\[", "\\\\]", "$1\\\\$2", "$1\\\\$2", "\\\\!", "\\\\|", "$1\\\\$2"};
    private Map emoticonMap = null;
    public static final String VALID_START = "(?<![}\\p{L}\\p{Nd}\\\\])";
    public static final String VALID_END = "(?![{\\p{L}\\p{Nd}])";
    private static final String PHRASE_CLEANUP_REGEX = "\\{((?:\\?\\?)|(?:\\*)|(?:\\^)|(?:~)|(?:_)|(?:-)|(?:\\+)|(?:\\{\\{)|(?:\\}\\}))\\}";

    public DefaultWysiwygConverter() {
        this.macrosToIgnore.add("color");
        this.sepMap = new HashMap();
        for (int i = 0; i < separators.length; ++i) {
            this.sepMap.put(separators[i], separators[i]);
        }
    }

    public void setWikiStyleRenderer(WikiStyleRenderer renderer) {
        this.renderer = renderer;
    }

    public void setMacroManager(MacroManager macroManager) {
        this.macroManager = macroManager;
    }

    public String getSep(Node previous, String current, boolean inTable, boolean inList) {
        String sep;
        Separation s;
        String prevType;
        if (previous == null) {
            prevType = null;
        } else if (DefaultWysiwygConverter.isTextNode(previous) || this.isWikiSrcDiv(previous)) {
            prevType = "text";
        } else if (DefaultWysiwygConverter.isForcedNewline(previous)) {
            prevType = "forcedNewline";
        } else if (DefaultWysiwygConverter.isList(previous)) {
            prevType = "list";
        } else {
            prevType = previous.getNodeName().toLowerCase();
            if (prevType.equals("span") || prevType.equals("b") || prevType.equals("em") || prevType.equals("del") || prevType.equals("ins") || prevType.equals("sub") || prevType.equals("sup")) {
                prevType = "text";
            } else if (DefaultWysiwygConverter.isHeading(prevType)) {
                prevType = "heading";
            } else if (this.isEmoticon(previous, prevType)) {
                prevType = "emoticon";
            }
        }
        String debugStr1 = "";
        String debugStr2 = "";
        if (debug) {
            debugStr1 = "[" + prevType + "-" + current;
            debugStr2 = inTable + "," + inList + "]";
        }
        if ((s = (Separation)this.sepMap.get(new Separation(prevType, current, null, null))) == null) {
            return debugStr1 + debugStr2;
        }
        String string = inTable ? s.getTableSeparator() : (sep = inList ? s.getListSeparator() : s.getSeparator());
        if (sep == null) {
            return debugStr1 + debugStr2;
        }
        return debugStr1 + sep + debugStr2;
    }

    private boolean isEmoticon(Node node, String nodeName) {
        String src;
        return nodeName.equals("img") && this.getAttribute(node, "src") != null && (src = node.getAttributes().getNamedItem("src").getNodeValue()).indexOf("/images/icons/emoticons/") != -1;
    }

    private boolean isWikiSrcDiv(Node node) {
        return this.getAttribute(node, "class") != null && this.getAttribute(node, "class").indexOf("wikisrc") != -1;
    }

    private static boolean isTextNode(Node node) {
        return node.getNodeType() == 3;
    }

    private static boolean isList(Node node) {
        return node.getNodeName().toLowerCase().equals("ol") || node.getNodeName().toLowerCase().equals("ul");
    }

    private boolean isNewList(Node parentNode) {
        if (parentNode == null) {
            return false;
        }
        String parentNodeName = parentNode.getNodeName().toLowerCase();
        if (!(parentNodeName.equals("li") || parentNodeName.equals("ul") || parentNodeName.equals("ol"))) {
            return true;
        }
        for (int i = 0; i < parentNode.getChildNodes().getLength(); ++i) {
            Node n = parentNode.getChildNodes().item(i);
            if (!n.getNodeName().toLowerCase().equals("div") || !this.isWikiSrcDiv(n)) continue;
            return true;
        }
        return false;
    }

    public String convertChildren(Node node, Styles styles, ListContext listContext, boolean inTable, boolean inListItem, boolean ignoreText, boolean escapeWikiMarkup, Node previousSibling) {
        StringBuffer wikiText = new StringBuffer();
        if (node != null && node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node n = node.getChildNodes().item(i);
                String converted = this.convertNode(n, previousSibling, styles, listContext, inTable, inListItem, ignoreText, escapeWikiMarkup);
                if (converted == null) continue;
                wikiText.append(converted);
                previousSibling = n;
            }
        }
        return wikiText.toString();
    }

    private boolean isTextNodeContainingWhitespaceOnly(Node n) {
        if (DefaultWysiwygConverter.isTextNode(n)) {
            String s = n.getNodeValue();
            return (s = s.replaceAll("(\n|\r|\t)+ *", "")).length() == 0;
        }
        return false;
    }

    private String convertNode(Node node, Node previousSibling, Styles styles, ListContext listContext, boolean inTable, boolean inListItem, boolean ignoreText, boolean escapeWikiMarkup) {
        if (this.isCommentNode(node)) {
            return null;
        }
        if (this.isProcessingInstructionNode(node)) {
            String s = this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
            return s;
        }
        if (this.isDocumentFragmentNode(node)) {
            String s = this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
            return s;
        }
        if (DefaultWysiwygConverter.isTextNode(node)) {
            if (ignoreText) {
                return null;
            }
            String s = node.getNodeValue();
            s = s.replaceAll("^\n", "");
            s = s.replaceAll("\n$", "");
            s = s.replaceAll("(\n|\r)", " ");
            if (this.isTextNodeContainingWhitespaceOnly(node)) {
                return null;
            }
            if (s.trim().equals("")) {
                return " ";
            }
            StringBuffer sb = new StringBuffer();
            if (s.startsWith(" ")) {
                sb.append(TEXT_SEPERATOR);
            }
            String sTrimmed = s.trim();
            sTrimmed = this.escapeWikiMarkup(sTrimmed);
            sb.append(styles.decorateText(sTrimmed));
            if (!s.equals(" ") && s.endsWith(" ")) {
                sb.append(TEXT_SEPERATOR);
            }
            return this.getSep(previousSibling, "text", inTable, inListItem) + this.replaceEntities(sb.toString());
        }
        String name = node.getNodeName().toLowerCase();
        if (name == null) {
            log.error((Object)("Node with null name, of class " + node.getClass()));
            return null;
        }
        if (this.getAttribute(node, "wysiwyg") != null) {
            String converterName = this.getAttribute(node, "wysiwyg");
            if (converterName.equals("ignore")) {
                return "";
            }
            WysiwygNodeConverter c = this.findNodeConverter(converterName);
            return c.convertXHtmlToWikiMarkup(previousSibling, node, this, styles, listContext, inTable, inListItem, false);
        }
        if (name.equals("br")) {
            if (DefaultWysiwygConverter.isForcedNewline(node)) {
                return this.getSep(previousSibling, "forcedNewline", inTable, inListItem) + "\\\\ ";
            }
            return this.getSep(previousSibling, "br", inTable, inListItem) + (inTable ? "\\\\\n " : "\n");
        }
        if (name.equals("p")) {
            String children = this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
            if (children.trim().equals("")) {
                return null;
            }
            if (children.trim().equals("&nbsp;")) {
                return this.getSep(previousSibling, "forcedNewline", inTable, inListItem) + "\\\\ ";
            }
            String s = this.getSep(previousSibling, "p", inTable, inListItem) + children;
            return s;
        }
        if (name.equals("span")) {
            if (this.getAttribute(node, "class") != null && this.getAttribute(node, "class").indexOf("macro") != -1) {
                if (this.getAttribute(node, "macrotext") != null) {
                    String macroText = this.getAttribute(node, "macrotext");
                    String command = this.getAttribute(node, "command");
                    String childText = this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
                    if (this.macrosToIgnore.contains(command)) {
                        return this.getSep(previousSibling, "text", inTable, inListItem) + childText;
                    }
                    String s = this.getSep(previousSibling, "text", inTable, inListItem) + macroText + childText + "{" + command + "}";
                    return s;
                }
                return this.getSep(previousSibling, "text", inTable, inListItem) + this.getRawChildText(node, true);
            }
            if (this.getAttribute(node, "class") != null && this.getAttribute(node, "class").indexOf("wikisrc") != -1) {
                return this.getRawChildText(node, false);
            }
            if (this.getAttribute(node, "class") != null && this.getAttribute(node, "class").indexOf("error") != -1) {
                return "";
            }
            return this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, false, escapeWikiMarkup, previousSibling);
        }
        if (name.equals("font")) {
            return this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
        }
        if (name.equals("b") || name.equals("strong")) {
            Styles st = new Styles(node, styles);
            return this.getSep(previousSibling, "text", inTable, inListItem) + this.convertChildren(node, new Styles("font-weight: bold", st), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
        }
        if (name.equals("i") || name.equals("em")) {
            Styles st = new Styles(node, styles);
            return this.getSep(previousSibling, "text", inTable, inListItem) + this.convertChildren(node, new Styles("font-style: italic", st), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
        }
        if (name.equals("del") || name.equals("strike")) {
            Styles st = new Styles(node, styles);
            return this.getSep(previousSibling, "text", inTable, inListItem) + this.convertChildren(node, new Styles("text-decoration: line-through", st), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
        }
        if (name.equals("ins") || name.equals("u")) {
            Styles st = new Styles(node, styles);
            return this.getSep(previousSibling, "text", inTable, inListItem) + this.convertChildren(node, new Styles("text-decoration: underline", st), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
        }
        if (name.equals("sub")) {
            Styles st = new Styles(node, styles);
            return this.getSep(previousSibling, "text", inTable, inListItem) + this.convertChildren(node, new Styles("baseline-shift: sub", st), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
        }
        if (name.equals("sup")) {
            Styles st = new Styles(node, styles);
            return this.getSep(previousSibling, "text", inTable, inListItem) + this.convertChildren(node, new Styles("baseline-shift: sup", st), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
        }
        if (name.equals("cite")) {
            Styles st = new Styles(node, styles);
            return this.getSep(previousSibling, "text", inTable, inListItem) + this.convertChildren(node, new Styles("style-citation", st), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
        }
        if (name.equals("ol")) {
            String s = this.getSep(previousSibling, "list", inTable, inListItem) + this.convertChildren(node, styles, new ListContext("#", listContext), inTable, inListItem, true, escapeWikiMarkup, null).trim();
            return s;
        }
        if (name.equals("ul")) {
            String bulletType = "*";
            String typeAttribute = this.getAttribute(node, "type");
            if (typeAttribute != null && typeAttribute.equals("square")) {
                bulletType = "-";
            }
            listContext = this.isNewList(node.getParentNode()) ? new ListContext(bulletType) : new ListContext(bulletType, listContext);
            String s = this.getSep(previousSibling, "list", inTable, inListItem) + this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, true, escapeWikiMarkup, null);
            return s;
        }
        if (name.equals("li")) {
            String s = this.trimNewlines(this.convertChildren(node, new Styles(node, styles), listContext, inTable, true, false, escapeWikiMarkup, null));
            if (s.equals("") || s.trim().equals("\\\\")) {
                s = "&nbsp;";
            }
            while (s.endsWith("\n")) {
                s = s.substring(0, s.length() - 1);
            }
            while (s.endsWith("\\\\\n ")) {
                s = s.substring(0, s.length() - 4);
            }
            if (s.trim().startsWith("##") || s.trim().startsWith("**")) {
                return this.getSep(previousSibling, "li", inTable, inListItem) + s;
            }
            return this.getSep(previousSibling, "li", inTable, inListItem) + listContext.decorateText(s);
        }
        if (name.equals("table")) {
            return this.getSep(previousSibling, "table", inTable, inListItem) + this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, true, escapeWikiMarkup, null);
        }
        if (name.equals("tbody")) {
            return this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, true, escapeWikiMarkup, null);
        }
        if (name.equals("tr")) {
            String s = this.convertChildren(node, new Styles(node, styles), listContext, true, inListItem, true, escapeWikiMarkup, null);
            if (s.length() > 0) {
                s = s.startsWith("||") ? s + "||" : s + "|";
                return this.getSep(previousSibling, "tr", inTable, inListItem) + s;
            }
            return "";
        }
        if (name.equals("th")) {
            String s = this.convertChildren(node, new Styles(node, styles), listContext, true, inListItem, false, escapeWikiMarkup, null);
            s = this.trimTableCell(s);
            return "||" + s;
        }
        if (name.equals("td")) {
            String s = this.convertChildren(node, new Styles(node, styles), listContext, true, inListItem, false, escapeWikiMarkup, null);
            s = this.trimTableCell(s);
            return "|" + s;
        }
        if (name.equals("div")) {
            if (this.getAttribute(node, "class") != null && this.getAttribute(node, "class").indexOf("error") != -1) {
                return "";
            }
            if (this.getAttribute(node, "class") != null && this.getAttribute(node, "class").indexOf("macro") != -1) {
                if (this.getAttribute(node, "macrotext") != null) {
                    String macroText = this.getAttribute(node, "macrotext");
                    String command = this.getAttribute(node, "command");
                    String childText = this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
                    return this.getSep(previousSibling, "div", inTable, inListItem) + macroText + "\n" + this.trimNewlinesAndEscapedNewlines(childText) + "\n" + "{" + command + "}";
                }
                return this.getSep(previousSibling, "div", inTable, inListItem) + this.getRawChildText(node, true);
            }
            if (this.isWikiSrcDiv(node)) {
                String s = this.getRawChildText(node, false);
                return s;
            }
            return this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, false, escapeWikiMarkup, previousSibling);
        }
        if (DefaultWysiwygConverter.isHeading(name)) {
            String digit = name.substring(1);
            return "\n" + this.getSep(previousSibling, "heading", inTable, inListItem) + "h" + digit + ". " + this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, false, escapeWikiMarkup, null) + "\n";
        }
        if (name.equals("img")) {
            String src;
            if (this.getAttribute(node, "imagetext") != null) {
                String imagetext = this.getAttribute(node, "imagetext");
                if (this.getAttribute(node, "width") != null) {
                    String params = "";
                    if (imagetext.indexOf("width=") != -1) {
                        imagetext = imagetext.replaceAll("width=\\d*", "width=" + this.getAttribute(node, "width"));
                    } else {
                        params = params + "width=" + this.getAttribute(node, "width");
                    }
                    if (this.getAttribute(node, "height") != null) {
                        if (imagetext.indexOf("height=") != -1) {
                            imagetext = imagetext.replaceAll("height=\\d*", "height=" + this.getAttribute(node, "height"));
                        } else {
                            params = params + ",height=" + this.getAttribute(node, "height");
                        }
                    }
                    if (TextUtils.stringSet((String)params)) {
                        imagetext = imagetext.indexOf("|") == -1 ? imagetext + "|" + params : imagetext + "," + params;
                    }
                }
                return this.getSep(previousSibling, "imagelink", inTable, inListItem) + TEXT_SEPERATOR + "!" + imagetext + "!";
            }
            if (this.getAttribute(node, "src") != null && (src = node.getAttributes().getNamedItem("src").getNodeValue()).indexOf("/images/icons/emoticons/") != -1) {
                return this.lookupEmoticonString(src.substring(src.indexOf("icons/emoticons/")));
            }
            return "";
        }
        if (name.equals("a")) {
            if (this.getAttribute(node, "linktype") != null) {
                if ("linkerror".equals(this.getAttribute(node, "class"))) {
                    return "[" + this.getAttribute(node, "linktext") + "]";
                }
                String alias = this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, false, false, previousSibling);
                String linkWikiText = WysiwygLinkHelper.createLinkWikiText(node, alias, this.getRawChildText(node, true));
                return this.getSep(previousSibling, "a", inTable, inListItem) + styles.decorateText(linkWikiText);
            }
            return this.getRawChildText(node, true);
        }
        if (name.equals("pre") || name.equals("textarea")) {
            String s = this.getSep(previousSibling, "pre", inTable, inListItem) + this.getRawChildText(node, false);
            return s;
        }
        if (name.equals("hr")) {
            return "\n\n----";
        }
        if (name.equals("link")) {
            return "";
        }
        if (name.equals("blockquote")) {
            if (this.getAttribute(node, "markup") != null) {
                int childLength = node.getChildNodes().getLength();
                if (childLength == 1) {
                    node = node.getChildNodes().item(0);
                }
                String s = this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
                return "\nbq. " + s;
            }
            return this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, false, escapeWikiMarkup, null);
        }
        if (name.equals("tt")) {
            return "{{{}" + this.convertChildren(node, new Styles(node, styles), listContext, inTable, inListItem, false, escapeWikiMarkup, null) + "{}}}";
        }
        return this.getRawChildText(node, true);
    }

    private String trimNewlinesAndEscapedNewlines(String s) {
        if (s.startsWith("\n")) {
            s = s.substring(1);
        }
        if (s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.startsWith("\\\\\n")) {
            s = s.substring(3);
        }
        if (s.endsWith("\\\\")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    private boolean isDocumentFragmentNode(Node node) {
        return node.getNodeType() == 11;
    }

    private boolean isProcessingInstructionNode(Node node) {
        return node.getNodeType() == 7;
    }

    private boolean isCommentNode(Node node) {
        return node.getNodeType() == 8;
    }

    private String trimWhitespace(String s) {
        return s.replace('\u00a0', ' ').trim();
    }

    private String trimNewlines(String s) {
        if (s.startsWith("\n")) {
            s = s.replaceAll("^\n*(.*?)", "$1");
        }
        return s;
    }

    private WysiwygNodeConverter findNodeConverter(String converterName) {
        if (converterName.startsWith("macro:")) {
            String[] parts = converterName.split(":");
            if (parts.length != 2) {
                throw new RuntimeException("Illegal node converter name:'" + converterName + "'");
            }
            Macro m = this.macroManager.getEnabledMacro(parts[1]);
            if (m instanceof ResourceAwareMacroDecorator) {
                m = ((ResourceAwareMacroDecorator)m).getMacro();
            }
            if (!(m instanceof WysiwygNodeConverter)) {
                throw new RuntimeException("Macro '" + parts[1] + "' implemented by " + m.getClass() + " does not implement WysiwygNodeConverter.");
            }
            return (WysiwygNodeConverter)((Object)m);
        }
        throw new RuntimeException("Unrecognized node converter name:'" + converterName + "'");
    }

    public String getAttribute(Node node, String name) {
        NamedNodeMap map = node.getAttributes();
        if (map == null) {
            log.error((Object)("Node " + node + " has null attribute map."));
            return null;
        }
        Node n = node.getAttributes().getNamedItem(name);
        return n != null ? n.getNodeValue() : null;
    }

    private static boolean isHeading(String name) {
        return name.startsWith("h") && name.length() == 2 && Character.isDigit(name.charAt(1));
    }

    private static boolean isForcedNewline(Node node) {
        return node != null && node.getNodeName() != null && node.getNodeName().toLowerCase().equals("br") && node.getAttributes() != null && node.getAttributes().getNamedItem("clear") != null;
    }

    private synchronized void initEmoticonMap() {
        this.emoticonMap = new HashMap();
        ArrayList<String> symbolList = new ArrayList<String>(Arrays.asList(this.iconManager.getEmoticonSymbols()));
        Collections.sort(symbolList);
        Iterator i = symbolList.iterator();
        while (i.hasNext()) {
            String symbol = (String)i.next();
            Icon icon = this.iconManager.getEmoticon(symbol);
            this.emoticonMap.put(icon.getPath(), symbol);
        }
    }

    private String lookupEmoticonString(String fileName) {
        String symbol;
        if (this.emoticonMap == null) {
            this.initEmoticonMap();
        }
        if ((symbol = (String)this.emoticonMap.get(fileName)) == null) {
            throw new RuntimeException("unrecognised emoticon " + fileName);
        }
        return symbol;
    }

    private String replaceEntities(String s) {
        return s.replaceAll("\\u2014", "---").replaceAll("\\u2013", "--").replaceAll("\\u00A0", "&nbsp;");
    }

    private String getRawChildText(Node node, boolean stripNewlines) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node n = node.getChildNodes().item(i);
            if (DefaultWysiwygConverter.isTextNode(n)) {
                String s = n.getNodeValue();
                if (stripNewlines) {
                    s = s.replaceAll("(\n|\r)", " ").trim();
                }
                sb.append(s);
            } else if (this.getNodeName(n).equals("br")) {
                sb.append("\n");
            }
            sb.append(this.getRawChildText(n, stripNewlines));
            if (!this.getNodeName(n).equals("p")) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private String getNodeName(Node node) {
        return node.getNodeName().toLowerCase();
    }

    private String trimTableCell(String s) {
        String trimmed = this.trimWhitespace(s);
        trimmed = trimmed.replaceAll("^&nbsp;", "");
        if ((trimmed = trimmed.replaceAll("&nbsp;$", "")).equals("&nbsp;")) {
            s = " ";
        }
        s = trimmed.equals("") ? " " : " " + trimmed + " ";
        return s;
    }

    private String escapeWikiMarkup(String s) {
        if (!debug) {
            for (int i = 0; i < escapedCharactersRegex.length; ++i) {
                s = s.replaceAll(escapedCharactersRegex[i], escapedCharactersReplacement[i]);
            }
        }
        return s;
    }

    public void setIconManager(IconManager iconManager) {
        this.iconManager = iconManager;
    }

    public String getMacroInfoHtml(RenderContext context, String name, int xOffset, int yOffset) {
        return "<img alt=\"" + name + "\" style=\"float:left;margin-right:-32;opacity:0.75;position:relative;left:" + xOffset + "px;top:" + yOffset + "px;\" src=\"" + context.getSiteRoot() + "/includes/js/editor/plugins/confluence/info.png\"/>";
    }

    public String convertXHtmlToWikiMarkup(String xhtml) {
        if (!TextUtils.stringSet((String)xhtml)) {
            return "";
        }
        try {
            xhtml = xhtml.replaceAll("\r", "");
            xhtml = xhtml.replaceAll("\\u2009", "");
            xhtml = xhtml.replaceAll("&#8201;", "");
            DOMFragmentParser parser = new DOMFragmentParser();
            HTMLDocumentImpl document = new HTMLDocumentImpl();
            DocumentFragment fragment = document.createDocumentFragment();
            xhtml = xhtml.replaceAll("<\\?xml.*?/>", "");
            InputSource inputSource = new InputSource(new StringReader(xhtml));
            try {
                parser.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
                if (debug) {
                    parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)new XMLDocumentFilter[]{new Writer()});
                }
                parser.parse(inputSource, fragment);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            StringBuffer wikiText = new StringBuffer();
            wikiText.append(this.convertNode(fragment, null, new Styles(), new ListContext(), false, false, false, true));
            if (debug) {
                return wikiText.toString();
            }
            String s = wikiText.toString().replaceAll("[\\s&&[^\n]]*\n", "\n").trim();
            s = s.replaceAll(" (TEXTSEP)+", " ");
            s = s.replaceAll("\n(TEXTSEP)+", "\n");
            s = s.replaceAll("^(TEXTSEP)+", "");
            s = s.replaceAll("\\[(TEXTSEP)+", "[");
            s = s.replaceAll("(TEXTSEP)+ ", " ");
            s = s.replaceAll("(TEXTSEP)+", " ");
            s = s.replaceAll(" \n", "\n");
            s = s.replaceAll("(?<![}\\p{L}\\p{Nd}\\\\])\\{((?:\\?\\?)|(?:\\*)|(?:\\^)|(?:~)|(?:_)|(?:-)|(?:\\+)|(?:\\{\\{)|(?:\\}\\}))\\}", "$1");
            s = s.replaceAll("\\{((?:\\?\\?)|(?:\\*)|(?:\\^)|(?:~)|(?:_)|(?:-)|(?:\\+)|(?:\\{\\{)|(?:\\}\\}))\\}(?![{\\p{L}\\p{Nd}])", "$1");
            return s;
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String convertWikiMarkupToXHtml(RenderContext ctx, String wikiMarkup) {
        ctx.setRenderingForWysiwyg(true);
        String s = this.renderer.convertWikiToXHtml(ctx, wikiMarkup);
        s = s.replaceAll("<p class=\"atl_conf_pad\">&#8201;</p>\\s*<p", "<p");
        return s;
    }

    private static void print(Node node, String indent) {
        System.out.println(indent + node.getClass().getName());
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            DefaultWysiwygConverter.print(child, indent + " ");
        }
    }

    private static class Separation {
        private final String previous;
        private final String current;
        private final String separator;
        private final String tableSeparator;
        private final String listSeparator;

        public String getSeparator() {
            return this.separator;
        }

        public String getTableSeparator() {
            return this.tableSeparator;
        }

        public String getListSeparator() {
            return this.listSeparator;
        }

        public Separation(String previous, String current, String separator, String tableSeparator, String listSeparator) {
            this.previous = previous;
            this.current = current;
            this.separator = separator;
            this.tableSeparator = tableSeparator;
            this.listSeparator = listSeparator;
        }

        public Separation(String previous, String current, String separator, String tableSeparator) {
            this.previous = previous;
            this.current = current;
            this.separator = separator;
            this.tableSeparator = tableSeparator;
            this.listSeparator = separator;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Separation) {
                Separation s = (Separation)obj;
                return (this.previous == null && s.previous == null || this.previous.equals(s.previous)) && (this.current == null && s.current == null || this.current.equals(s.current));
            }
            return false;
        }

        public int hashCode() {
            return 43 * (this.previous == null ? 1 : this.previous.hashCode()) + (this.current == null ? 1 : this.current.hashCode());
        }
    }
}

