/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components.table;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.Renderable;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.components.table.TableRow;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class Table
implements Renderable {
    List rows = new LinkedList();

    public void addRow(String s) {
        this.addRow(TableRow.createRow(s));
    }

    public void addRow(TableRow row) {
        this.rows.add(row);
    }

    public void render(SubRenderer subRenderer, RenderContext context, StringBuffer buff) {
        buff.append("<table class='confluenceTable'><tbody>\n");
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            TableRow tableRow = (TableRow)iterator.next();
            tableRow.render(subRenderer, context, buff);
        }
        buff.append("</tbody></table>");
    }

    public static Table createTable(String raw) {
        Table t = new Table();
        StringTokenizer st = new StringTokenizer(raw, "\n");
        if (st.countTokens() > 0) {
            String currentRow = st.nextToken();
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.charAt(0) == '|') {
                    t.addRow(currentRow);
                    currentRow = s;
                    continue;
                }
                currentRow = currentRow + "\n" + s;
            }
            t.addRow(currentRow);
        }
        return t;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table table = (Table)o;
        return !(this.rows != null ? !((Object)this.rows).equals(table.rows) : table.rows != null);
    }

    public int hashCode() {
        return this.rows != null ? ((Object)this.rows).hashCode() : 0;
    }
}

