/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components.block;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Stack;

public class LineWalker {
    private BufferedReader reader;
    private String nextLine;
    private Stack pushedBackLines = new Stack();

    public LineWalker(String text) {
        this.reader = new BufferedReader(new StringReader(text));
    }

    public boolean hasNext() {
        try {
            if (this.nextLine == null && this.pushedBackLines.empty()) {
                this.nextLine = this.reader.readLine();
            }
            return this.nextLine != null || !this.pushedBackLines.empty();
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception reading from string: " + e.getMessage(), e);
        }
    }

    public String peek() {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more lines");
        }
        if (!this.pushedBackLines.empty()) {
            return (String)this.pushedBackLines.peek();
        }
        return this.nextLine;
    }

    public String next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more lines");
        }
        if (!this.pushedBackLines.empty()) {
            return (String)this.pushedBackLines.pop();
        }
        String retval = this.nextLine;
        this.nextLine = null;
        return retval;
    }

    public void pushBack(String line) {
        this.pushedBackLines.push(line);
    }
}

