/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components.block;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.RenderedContentStore;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.components.RendererComponent;
import com.atlassian.renderer.v2.components.block.BlockRenderer;
import com.atlassian.renderer.v2.components.block.LineWalker;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class BlockRendererComponent
implements RendererComponent {
    private static final Pattern TOKEN_ONLY_PATTERN = Pattern.compile("(\\s*" + RenderedContentStore.BLOCK_TOKEN.getString() + ")+\\s*", 8);
    private static final Pattern SINGLE_LINE_PARA = Pattern.compile("\\s*[\\p{Alnum}&&[^PLhb]][^\n]*");
    private BlockRenderer[] blockRenderers;
    private final SubRenderer subRenderer;

    public BlockRendererComponent(SubRenderer subRenderer, List blockRenderers) {
        this.subRenderer = subRenderer;
        this.blockRenderers = blockRenderers.toArray(new BlockRenderer[blockRenderers.size()]);
    }

    public void setBlockRenderers(List blockRenderers) {
        this.blockRenderers = blockRenderers.toArray(new BlockRenderer[blockRenderers.size()]);
    }

    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderParagraphs();
    }

    public String render(String wiki, RenderContext context) {
        if (SINGLE_LINE_PARA.matcher(wiki).matches() && !TOKEN_ONLY_PATTERN.matcher(wiki).matches()) {
            return context.addRenderedContent(this.renderParagraph(true, context, wiki));
        }
        LineWalker walker = new LineWalker(wiki);
        ArrayList<String> renderedLines = new ArrayList<String>();
        ArrayList<String> paragraph = new ArrayList<String>();
        boolean firstPara = true;
        while (walker.hasNext()) {
            String nextLine = walker.next();
            String rendered = null;
            if (TOKEN_ONLY_PATTERN.matcher(nextLine).matches()) {
                rendered = nextLine;
            } else if (!SINGLE_LINE_PARA.matcher(wiki).matches()) {
                BlockRenderer blockRenderer;
                for (int i = 0; i < this.blockRenderers.length && (rendered = (blockRenderer = this.blockRenderers[i]).renderNextBlock(nextLine, walker, context, this.subRenderer)) == null; ++i) {
                }
            }
            if (rendered == null) {
                paragraph.add(nextLine);
                continue;
            }
            this.flushParagraph(renderedLines, paragraph, context, firstPara);
            renderedLines.add(rendered);
            firstPara = false;
        }
        this.flushParagraph(renderedLines, paragraph, context, firstPara);
        return context.addRenderedContent(TextUtils.join((String)"\n", renderedLines));
    }

    private void flushParagraph(List renderedLines, List remainderedLines, RenderContext context, boolean firstParagraph) {
        if (remainderedLines.isEmpty()) {
            return;
        }
        String paragraph = TextUtils.join((String)"\n", (Collection)remainderedLines);
        renderedLines.add(this.renderParagraph(firstParagraph, context, paragraph));
        remainderedLines.clear();
    }

    private String renderParagraph(boolean firstParagraph, RenderContext context, String paragraph) {
        if (firstParagraph && !context.getRenderMode().renderFirstParagraph()) {
            return this.subRenderer.render(paragraph, context, context.getRenderMode().and(RenderMode.INLINE));
        }
        return "<p>" + this.subRenderer.render(paragraph, context, context.getRenderMode().and(RenderMode.INLINE)) + "</p>";
    }
}

