/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.components;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.embedded.EmbeddedResource;
import com.atlassian.renderer.embedded.EmbeddedResourceRenderer;
import com.atlassian.renderer.embedded.EmbeddedResourceResolver;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.AbstractRegexRendererComponent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmbeddedRendererComponent
extends AbstractRegexRendererComponent {
    static final Pattern IMAGE_PATTERN = Pattern.compile(EmbeddedRendererComponent.buildPhraseRegExp("\\!", "\\!"));

    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderImages();
    }

    public String render(String wiki, RenderContext context) {
        if (wiki.indexOf("!") == -1) {
            return wiki;
        }
        return this.regexRender(wiki, context, IMAGE_PATTERN);
    }

    public void appendSubstitution(StringBuffer buffer, RenderContext context, Matcher matcher) {
        String matchStr = matcher.group(2);
        if (matchStr.length() < 5 || matchStr.charAt(0) == ')') {
            buffer.append("!").append(matchStr).append("!");
            return;
        }
        EmbeddedResource r = EmbeddedResourceResolver.create(matcher.group(2));
        EmbeddedResourceRenderer renderer = context.getEmbeddedResourceRenderer();
        buffer.append(context.getRenderedContentStore().addInline(renderer.renderResource(r, context)));
    }

    private static String buildPhraseRegExp(String phrase_start_sign, String phrase_end_sign) {
        String valid_start = "(?<![\\p{L}\\p{Nd}\\\\])";
        String valid_end = "(?![\\p{L}\\p{Nd}])";
        String phrase_content = "[^\\s" + phrase_start_sign + "]((?!" + phrase_end_sign + ")[\\p{L}\\p{Nd}\\p{Z}\\p{S}\\p{M}\\p{P}]*?[^\\s" + phrase_end_sign + "])?";
        return "(^|" + valid_start + ")" + phrase_start_sign + "(" + phrase_content + ")(?<!\\\\)" + phrase_end_sign + "(" + valid_end + "|$)";
    }
}

