/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.links;

import com.atlassian.renderer.links.BaseLink;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.util.RendererProperties;
import java.text.ParseException;
import java.util.Arrays;
import org.apache.log4j.Category;

public class UrlLink
extends BaseLink {
    private static Category log = Category.getInstance((Class)UrlLink.class);
    public static final String EXTERNAL_ICON = "external";
    public static final String MAILTO_ICON = "mailto";

    public UrlLink(String url, String linkBody) throws ParseException {
        this(new GenericLinkParser(url));
        this.linkBody = linkBody;
    }

    public UrlLink(GenericLinkParser parser) {
        super(parser);
        this.iconName = EXTERNAL_ICON;
        this.url = parser.getNotLinkBody();
        this.setI18nTitle(RendererProperties.URL_LINK_TITLE, null);
        if (this.url.startsWith("///")) {
            this.url = this.url.substring(2);
            this.relativeUrl = true;
            this.setI18nTitle(RendererProperties.SITE_RELATIVE_LINK_TITLE, null);
        } else if (this.url.startsWith("//")) {
            this.url = this.url.substring(1);
            this.setI18nTitle(RendererProperties.RELATIVE_LINK_TITLE, null);
        }
        if (this.url.startsWith("\\\\")) {
            this.url = "file:" + this.url.replaceAll("\\\\", "/");
        }
        if (this.isMailLink()) {
            if (parser.getLinkBody() == null) {
                this.linkBody = this.linkBody.substring(7);
            }
            this.setI18nTitle(RendererProperties.SEND_MAIL_TO, Arrays.asList(this.linkBody));
            this.iconName = MAILTO_ICON;
        }
    }

    public boolean isMailLink() {
        return this.url.startsWith("mailto:");
    }
}

