/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.xsrf.XsrfRequestValidator;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class XsrfRequestValidatorTest
extends SpringAwareTestCase {
    private XsrfRequestValidator xsrfRequestValidator;
    private XsrfTokenAccessor xsrfTokenAccessor;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;

    public void setXsrfRequestValidator(XsrfRequestValidator xsrfRequestValidator) {
        this.xsrfRequestValidator = xsrfRequestValidator;
    }

    public void setXsrfTokenAccessor(XsrfTokenAccessor xsrfTokenAccessor) {
        this.xsrfTokenAccessor = xsrfTokenAccessor;
    }

    @Before
    public void setUp() {
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
    }

    @Test
    public void testXsrfRequestValidatorAvailable() {
        Assert.assertNotNull((String)"XSRF Request Validator should be available to plugins", (Object)this.xsrfRequestValidator);
    }

    @Test
    public void testXsrfRequestHeaderValidation() {
        this.request.addHeader("X-Atlassian-Token", (Object)"no-check");
        Assert.assertTrue((boolean)this.xsrfRequestValidator.validateRequestPassesXsrfChecks((HttpServletRequest)this.request));
    }

    @Test
    public void testXsrfRequestFormValidation() {
        String token = this.xsrfTokenAccessor.getXsrfToken((HttpServletRequest)this.request, (HttpServletResponse)this.response, true);
        this.request.addParameter("atl_token", token);
        Cookie[] cookies = new Cookie[]{new Cookie("atl.xsrf.token", token)};
        this.request.setCookies(cookies);
        Assert.assertTrue((boolean)this.xsrfRequestValidator.validateRequestPassesXsrfChecks((HttpServletRequest)this.request));
    }

    @Test
    public void testXsrfRequestValidationFails() {
        Assert.assertFalse((boolean)this.xsrfRequestValidator.validateRequestPassesXsrfChecks((HttpServletRequest)this.request));
    }
}

