/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk;

import com.atlassian.plugin.util.ClassLoaderUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public final class PlatformVersionSpecReader {
    private static final String PLATFORM_VERSION_PATH = "com/atlassian/refapp/ctk/version/platformversions.xml";

    private PlatformVersionSpecReader() {
    }

    static Document readPlatformVersionDocument() throws RuntimeException {
        InputStream in = ClassLoaderUtils.getResourceAsStream((String)PLATFORM_VERSION_PATH, PlatformVersionSpecReader.class);
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(in);
            return document;
        }
        catch (DocumentException e) {
            throw new RuntimeException("Cannot read the platform version definition", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static String getPlatformVersion() throws RuntimeException {
        Document document = PlatformVersionSpecReader.readPlatformVersionDocument();
        String xPath = "/platform";
        List nodes = document.selectNodes(xPath);
        return ((Node)nodes.get(0)).valueOf("@version");
    }

    public static List<VersionCheck> getVersionChecks() {
        ArrayList<VersionCheck> versionChecks = new ArrayList<VersionCheck>();
        Document document = PlatformVersionSpecReader.readPlatformVersionDocument();
        List nodes = document.selectNodes("/platform/export-version-check");
        for (Node node : nodes) {
            String pkg = node.valueOf("@package");
            String version = node.valueOf("@version");
            String modulename = node.valueOf("@modulename");
            boolean optional = Boolean.parseBoolean(node.valueOf("@optional"));
            versionChecks.add(new ExportVersionCheck(pkg, version, modulename, optional));
        }
        List bundleCheckNodes = document.selectNodes("/platform/bundle-version-check");
        for (Node node : bundleCheckNodes) {
            String bundlename = node.valueOf("@bundlename");
            String version = node.valueOf("@version");
            String modulename = node.valueOf("@modulename");
            boolean optional = Boolean.parseBoolean(node.valueOf("@optional"));
            versionChecks.add(new BundleVersionCheck(bundlename, version, modulename, optional));
        }
        return versionChecks;
    }

    public static class ExportVersionCheck
    extends VersionCheck {
        private final String pkg;

        private ExportVersionCheck(String pkg, String version, String moduleName, boolean optional) {
            super(version, moduleName, optional);
            Validate.notEmpty((String)pkg);
            this.pkg = pkg;
        }

        public String getPkg() {
            return this.pkg;
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("pkg", (Object)this.pkg).append("optional", this.optional).toString();
        }
    }

    public static class BundleVersionCheck
    extends VersionCheck {
        private final String bundleName;

        private BundleVersionCheck(String bundleName, String version, String moduleName, boolean optional) {
            super(version, moduleName, optional);
            Validate.notEmpty((String)bundleName);
            this.bundleName = bundleName;
        }

        public String getBundleName() {
            return this.bundleName;
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("bundleName", (Object)this.bundleName).toString();
        }
    }

    public static abstract class VersionCheck {
        protected final String version;
        protected final String moduleName;
        protected final boolean optional;

        VersionCheck(String version, String moduleName, boolean optional) {
            Validate.notEmpty((String)version);
            Validate.notEmpty((String)moduleName);
            this.version = version;
            this.moduleName = moduleName;
            this.optional = optional;
        }

        public String getVersion() {
            return this.version;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("version", (Object)this.version).append("moduleName", (Object)this.moduleName).toString();
        }
    }
}

