/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.refapp.ctk.AppSpecificInfoProvider;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.features.EnabledDarkFeatures;
import com.atlassian.sal.api.features.InvalidFeatureKeyException;
import com.atlassian.sal.api.user.UserKey;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;

public class DarkFeaturesTest
extends SpringAwareTestCase {
    private static final String ENABLED_FEATURE = "foo";
    private static final String DISABLED_FEATURE = "bar";
    private static final String INVALID_FEATURE_KEY = "invalid feature key";
    private static final String ADMIN_USER_FEATURE = "launch-button.feature";
    private static final UserKey ANONYMOUS = null;
    private DarkFeatureManager darkFeatureManager;
    private AppSpecificInfoProvider infoProvider;

    public void setDarkFeatureManager(DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }

    public void setInfoProvider(AppSpecificInfoProvider infoProvider) {
        this.infoProvider = infoProvider;
    }

    @After
    public void disableAdminFeature() throws Exception {
        if (this.darkFeatureManager.isFeatureEnabledForUser(this.adminUser(), ADMIN_USER_FEATURE)) {
            this.darkFeatureManager.disableFeatureForUser(this.adminUser(), ADMIN_USER_FEATURE);
        }
    }

    @Test
    public void systemFeatureEnabledForAllUsers() {
        this.assertFeatureEnabled(this.darkFeatureManager.isFeatureEnabledForAllUsers(ENABLED_FEATURE));
    }

    @Test
    public void systemFeatureDisabledForAllUsers() {
        this.assertFeatureDisabled(this.darkFeatureManager.isFeatureEnabledForAllUsers(DISABLED_FEATURE));
    }

    @Test
    public void invalidFeatureKeyIsNeverEnabledForAllUsers() {
        this.assertInvalidFeatureDisabled(this.darkFeatureManager.isFeatureEnabledForAllUsers(INVALID_FEATURE_KEY));
    }

    @Test
    public void systemFeatureEnabledForAnonymous() {
        this.assertFeatureEnabled(this.darkFeatureManager.isFeatureEnabledForUser(ANONYMOUS, ENABLED_FEATURE));
    }

    @Test
    public void systemFeatureDisabledForAnonymous() {
        this.assertFeatureDisabled(this.darkFeatureManager.isFeatureEnabledForUser(ANONYMOUS, DISABLED_FEATURE));
    }

    @Test
    public void invalidFeatureKeyIsNeverEnabledForAnonymous() {
        this.assertInvalidFeatureDisabled(this.darkFeatureManager.isFeatureEnabledForUser(ANONYMOUS, INVALID_FEATURE_KEY));
    }

    @Test
    public void systemFeatureEnabledForAuthenticatedUser() {
        this.assertFeatureEnabled(this.darkFeatureManager.isFeatureEnabledForUser(this.adminUser(), ENABLED_FEATURE));
    }

    @Test
    public void systemFeatureDisabledForAuthenticatedUser() {
        this.assertFeatureDisabled(this.darkFeatureManager.isFeatureEnabledForUser(this.adminUser(), DISABLED_FEATURE));
    }

    @Test
    public void invalidFeatureKeyIsNeverEnabledForAuthenticatedUser() {
        this.assertInvalidFeatureDisabled(this.darkFeatureManager.isFeatureEnabledForUser(this.adminUser(), INVALID_FEATURE_KEY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void featureUndefinedForInvalidUser() {
        this.darkFeatureManager.isFeatureEnabledForUser(this.notExistingUser(), ENABLED_FEATURE);
    }

    @Test
    public void systemFeatureEnabledForCurrentUser() {
        this.assertFeatureEnabled(this.darkFeatureManager.isFeatureEnabledForCurrentUser(ENABLED_FEATURE));
    }

    @Test
    public void systemFeatureDisabledForCurrentUser() {
        this.assertFeatureDisabled(this.darkFeatureManager.isFeatureEnabledForCurrentUser(DISABLED_FEATURE));
    }

    @Test
    public void invalidFeatureKeyIsNeverEnabledForCurrentUser() {
        this.assertInvalidFeatureDisabled(this.darkFeatureManager.isFeatureEnabledForCurrentUser(INVALID_FEATURE_KEY));
    }

    @Test
    public void enableFeaturesForAllUsersContainsEnabledFeature() {
        this.assertFeatureEnabled(this.darkFeatureManager.getFeaturesEnabledForAllUsers());
    }

    @Test
    public void enabledFeaturesForAllUsersNotContainsDisabledFeature() {
        this.assertFeatureDisabled(this.darkFeatureManager.getFeaturesEnabledForAllUsers());
    }

    @Test
    public void enabledFeaturesForAnonymousContainsEnabledFeature() {
        this.assertFeatureEnabled(this.darkFeatureManager.getFeaturesEnabledForUser(null));
    }

    @Test
    public void enabledFeaturesForAnonymousNotContainsDisabledFeature() {
        this.assertFeatureDisabled(this.darkFeatureManager.getFeaturesEnabledForUser(null));
    }

    @Test
    public void enabledFeaturesForAuthenticatedUserContainsEnabledFeature() {
        this.assertFeatureEnabled(this.darkFeatureManager.getFeaturesEnabledForUser(this.adminUser()));
    }

    @Test
    public void enabledFeaturesForAuthenticatedUserNotContainsDisabledFeature() {
        this.assertFeatureDisabled(this.darkFeatureManager.getFeaturesEnabledForUser(this.adminUser()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void enabledFeaturesForInvalidUser() {
        this.darkFeatureManager.getFeaturesEnabledForUser(this.notExistingUser());
    }

    @Test
    public void enabledFeaturesForCurrentUserContainsEnabledFeature() {
        this.assertFeatureEnabled(this.darkFeatureManager.getFeaturesEnabledForCurrentUser());
    }

    @Test
    public void enabledFeaturesForCurrentUserNotContainsDisabledFeature() {
        this.assertFeatureDisabled(this.darkFeatureManager.getFeaturesEnabledForCurrentUser());
    }

    @Test(expected=InvalidFeatureKeyException.class)
    public void invalidFeatureKeyNotEnabledForAllUsers() {
        this.darkFeatureManager.enableFeatureForAllUsers(INVALID_FEATURE_KEY);
    }

    @Test(expected=InvalidFeatureKeyException.class)
    public void invalidFeatureKeyNotDisabledForAllUsers() {
        this.darkFeatureManager.disableFeatureForAllUsers(INVALID_FEATURE_KEY);
    }

    @Test
    public void invalidFeatureKeyNotEnabledForAuthenticatedUser() {
        try {
            this.darkFeatureManager.enableFeatureForUser(this.adminUser(), INVALID_FEATURE_KEY);
            Assert.fail((String)("Expected an " + InvalidFeatureKeyException.class.getName()));
        }
        catch (UnsupportedOperationException e) {
            this.ignoreTest();
        }
        catch (InvalidFeatureKeyException invalidFeatureKeyException) {
            // empty catch block
        }
    }

    @Test
    public void featureNotEnabledForNotExisingUser() {
        try {
            this.darkFeatureManager.enableFeatureForUser(this.notExistingUser(), ADMIN_USER_FEATURE);
            Assert.fail((String)("Expected an " + IllegalArgumentException.class.getName()));
        }
        catch (UnsupportedOperationException e) {
            this.ignoreTest();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void invalidFeatureKeyNotDisabledForAuthenticatedUser() {
        try {
            this.darkFeatureManager.disableFeatureForUser(this.adminUser(), INVALID_FEATURE_KEY);
            Assert.fail((String)("Expected an " + InvalidFeatureKeyException.class.getName()));
        }
        catch (UnsupportedOperationException e) {
            this.ignoreTest();
        }
        catch (InvalidFeatureKeyException invalidFeatureKeyException) {
            // empty catch block
        }
    }

    @Test
    public void featureNotDisabledForNotExisingUser() {
        try {
            this.darkFeatureManager.disableFeatureForUser(this.notExistingUser(), ADMIN_USER_FEATURE);
            Assert.fail((String)("Expected an " + IllegalArgumentException.class.getName()));
        }
        catch (UnsupportedOperationException e) {
            this.ignoreTest();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void invalidFeatureKeyNotEnabledForCurrentUser() {
        try {
            this.darkFeatureManager.enableFeatureForCurrentUser(INVALID_FEATURE_KEY);
            Assert.fail((String)("Expected an " + InvalidFeatureKeyException.class.getName()));
        }
        catch (UnsupportedOperationException e) {
            this.ignoreTest();
        }
        catch (InvalidFeatureKeyException e) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void invalidFeatureKeyNotDisabledForCurrentUser() {
        try {
            this.darkFeatureManager.disableFeatureForCurrentUser(INVALID_FEATURE_KEY);
            Assert.fail((String)("Expected an " + InvalidFeatureKeyException.class.getName()));
        }
        catch (UnsupportedOperationException e) {
            this.ignoreTest();
        }
        catch (InvalidFeatureKeyException e) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void changeFeatureForAuthenticatedUser() {
        try {
            this.darkFeatureManager.enableFeatureForUser(this.adminUser(), ADMIN_USER_FEATURE);
        }
        catch (UnsupportedOperationException e) {
            this.ignoreTest();
        }
        Assert.assertTrue((String)"Feature key 'launch-button.feature' must be enabled for the admin user", (boolean)this.darkFeatureManager.isFeatureEnabledForUser(this.adminUser(), ADMIN_USER_FEATURE));
        Assert.assertFalse((String)"Feature key 'launch-button.feature' must be disabled for all users", (boolean)this.darkFeatureManager.isFeatureEnabledForAllUsers(ADMIN_USER_FEATURE));
        this.darkFeatureManager.disableFeatureForUser(this.adminUser(), ADMIN_USER_FEATURE);
        Assert.assertFalse((String)"Feature key 'launch-button.feature' must be disabled for the admin user", (boolean)this.darkFeatureManager.isFeatureEnabledForUser(this.adminUser(), ADMIN_USER_FEATURE));
    }

    private void assertFeatureEnabled(boolean isEnabled) {
        Assert.assertTrue((String)"Feature key 'foo' must be enabled", (boolean)isEnabled);
    }

    private void assertFeatureEnabled(EnabledDarkFeatures enabledDarkFeatures) {
        Assert.assertTrue((String)("Feature key 'foo' must be enabled; found: " + enabledDarkFeatures), (boolean)enabledDarkFeatures.isFeatureEnabled(ENABLED_FEATURE));
    }

    private void assertFeatureDisabled(boolean isEnabled) {
        Assert.assertFalse((String)"Feature key bar' must be disabled", (boolean)isEnabled);
    }

    private void assertFeatureDisabled(EnabledDarkFeatures enabledDarkFeatures) {
        Assert.assertFalse((String)("Feature key 'bar' must be disabled; found: " + enabledDarkFeatures), (boolean)enabledDarkFeatures.isFeatureEnabled(DISABLED_FEATURE));
    }

    private void assertInvalidFeatureDisabled(boolean isEnabled) {
        Assert.assertFalse((String)"Invalid feature key must never be enabled.", (boolean)isEnabled);
    }

    private UserKey adminUser() {
        return this.infoProvider.getAdminUserKey();
    }

    private UserKey notExistingUser() {
        return new UserKey("somenonexistinguser");
    }

    private void ignoreTest() {
        throw new AssumptionViolatedException("The current application doesn't implement that feature");
    }
}

