/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Response;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.web.context.HttpContext;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;

public class ApplicationPropertiesTest
extends SpringAwareTestCase {
    private ApplicationProperties appProp;
    private HttpContext httpContext;
    private HttpClient httpClient;

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.appProp = applicationProperties;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Test
    public void testApplicationPropertiesAvailable() {
        Assert.assertNotNull((String)"ApplicationProperties should be available to plugins", (Object)this.appProp);
    }

    @Test
    public void testGetBuildDateNotNull() {
        Assert.assertNotNull((Object)this.appProp.getBuildDate());
    }

    @Test
    public void testGetBuildNumberNotNull() {
        Assert.assertNotNull((Object)this.appProp.getBuildNumber());
    }

    @Test
    public void testGetDisplayNameNotNull() {
        Assert.assertNotNull((Object)this.appProp.getDisplayName());
    }

    @Test
    public void testGetVersionNotNull() {
        Assert.assertNotNull((Object)this.appProp.getVersion());
    }

    @Test
    public void testGetBaseUrlNotNull() {
        Assert.assertNotNull((Object)this.appProp.getBaseUrl());
    }

    @Test
    public void testGetBaseUrlAccessible() throws IOException {
        Assert.assertEquals((String)"the base url must be accessible", (long)200L, (long)this.getUrlStatusCode(this.appProp.getBaseUrl()));
    }

    @Test
    public void testGetCanonicalBaseUrlAccessible() throws IOException {
        Assert.assertEquals((String)"the CANONICAL base url must be accessible", (long)200L, (long)this.getUrlStatusCode(this.appProp.getBaseUrl(UrlMode.CANONICAL)));
    }

    @Test
    public void testGetAbsoluteBaseUrlAccessible() throws IOException {
        Assert.assertEquals((String)"the ABSOLUTE base url must be accessible", (long)200L, (long)this.getUrlStatusCode(this.appProp.getBaseUrl(UrlMode.ABSOLUTE)));
    }

    @Test
    public void testGetRelativeBaseUrlAccessible() throws IOException {
        String contextPath = this.appProp.getBaseUrl(UrlMode.RELATIVE);
        String baseUrl = this.httpContext.getRequest().getRequestURL().toString();
        String url = new URL(new URL(baseUrl), contextPath).toString();
        Assert.assertEquals((String)"the RELATIVE base url must be accessible", (long)200L, (long)this.getUrlStatusCode(url));
    }

    @Test
    public void testGetRelativeCanonicalBaseUrlAccessible() throws IOException {
        String contextPath = this.appProp.getBaseUrl(UrlMode.RELATIVE_CANONICAL);
        String baseUrl = this.httpContext.getRequest().getRequestURL().toString();
        String url = new URL(new URL(baseUrl), contextPath).toString();
        Assert.assertEquals((String)"the RELATIVE_CANONICAL base url must be accessible", (long)200L, (long)this.getUrlStatusCode(url));
    }

    @Test
    public void testGetRelativeBaseUrlOnRequestThread() throws IOException {
        String contextPath = this.httpContext.getRequest().getContextPath();
        Assert.assertEquals((String)"the RELATIVE base url must be the context path on request threads", (Object)contextPath, (Object)this.appProp.getBaseUrl(UrlMode.RELATIVE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRelativeBaseUrlOnWorkerThread() throws Exception {
        String baseUrl = this.appProp.getBaseUrl(UrlMode.CANONICAL);
        URL url = new URL(baseUrl);
        String contextPath = url.getPath();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<String> result = executorService.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ApplicationPropertiesTest.this.appProp.getBaseUrl(UrlMode.RELATIVE);
                }
            });
            Assert.assertEquals((String)"the RELATIVE base url must be derived from CANONICAL on worker threads", (Object)contextPath, (Object)result.get());
        }
        finally {
            executorService.shutdown();
        }
    }

    @Test
    public void testGetAutoBaseUrlRelativeOnRequestThread() throws IOException {
        Assert.assertEquals((String)"the AUTO base url must be RELATIVE on request threads", (Object)this.appProp.getBaseUrl(UrlMode.RELATIVE), (Object)this.appProp.getBaseUrl(UrlMode.AUTO));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAutoBaseUrlCanonicalOnWorkerThread() throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<String> result = executorService.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ApplicationPropertiesTest.this.appProp.getBaseUrl(UrlMode.AUTO);
                }
            });
            Assert.assertEquals((String)"the AUTO base url must be CANONICAL on worker threads", (Object)this.appProp.getBaseUrl(UrlMode.CANONICAL), (Object)result.get());
        }
        finally {
            executorService.shutdown();
        }
    }

    @Test
    public void testGetHomeDirectoryNotNull() {
        Assert.assertNotNull((Object)this.appProp.getHomeDirectory());
    }

    @Test
    public void testHomeDirectoryMustExist() {
        Assert.assertTrue((String)"the home directory must exist", (boolean)this.appProp.getHomeDirectory().exists());
        Assert.assertTrue((String)"it must be a directory", (boolean)this.appProp.getHomeDirectory().isDirectory());
    }

    private int getUrlStatusCode(String url) {
        return ((Response)this.httpClient.newRequest(url).get().claim()).getStatusCode();
    }
}

