/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.fugue.Option;
import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.google.common.base.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UserSettingsTest
extends SpringAwareTestCase {
    public static final String USERNAME = "admin";
    public static final String NOT_A_USERNAME = "notauser";
    public static final String KEY_1 = "key1";
    public static final String STRING_VALUE = "Hello";
    public static final String TOO_LONG_STRING = StringUtils.repeat((String)"0", (int)256);
    public static final String MAX_LENGTH_VALUE_STRING = TOO_LONG_STRING.substring(0, TOO_LONG_STRING.length() - 1);
    public static final String MAX_LENGTH_KEY_STRING = StringUtils.repeat((String)"a", (int)UserSettingsService.MAX_KEY_LENGTH);
    public static final long LONG_VALUE = 100L;
    private UserSettingsService userSettingsService;

    public void setService(UserSettingsService userSettingsService) {
        this.userSettingsService = userSettingsService;
    }

    @Before
    public void setUp() {
        this.userSettingsService.updateUserSettings(USERNAME, (Function)new Function<UserSettingsBuilder, UserSettings>(){

            public UserSettings apply(@Nullable UserSettingsBuilder input) {
                for (String key : input.getKeys()) {
                    input.remove(key);
                }
                return input.build();
            }
        });
    }

    @Test
    public void userSettingsServiceShouldBeAvailable() {
        Assert.assertNotNull((String)"UserSettingsService should be available to plugins", (Object)this.userSettingsService);
    }

    @Test(expected=IllegalArgumentException.class)
    public void noUserGetFailsWithCorrectException() {
        this.userSettingsService.getUserSettings(NOT_A_USERNAME);
    }

    @Test(expected=IllegalArgumentException.class)
    public void noUserUpdateFailsWithCorrectException() {
        this.userSettingsService.updateUserSettings(NOT_A_USERNAME, (Function)new Function<UserSettingsBuilder, UserSettings>(){

            public UserSettings apply(@Nullable UserSettingsBuilder input) {
                Assert.assertFalse((boolean)true);
                return input.build();
            }
        });
    }

    @Test
    public void typedBooleanUpdateStoresOnlyBooleanType() {
        this.userSettingsService.updateUserSettings(USERNAME, (Function)new Function<UserSettingsBuilder, UserSettings>(){

            public UserSettings apply(UserSettingsBuilder input) {
                input.put(UserSettingsTest.KEY_1, true);
                return input.build();
            }
        });
        UserSettings userSettings = this.userSettingsService.getUserSettings(USERNAME);
        Option booleanValue = userSettings.getBoolean(KEY_1);
        Assert.assertFalse((String)"boolean value should be present", (boolean)booleanValue.isEmpty());
        Assert.assertTrue((String)"boolean value should be true", (boolean)((Boolean)booleanValue.get()));
        Option stringValue = userSettings.getString(KEY_1);
        Assert.assertTrue((String)"there should be no string type", (boolean)stringValue.isEmpty());
        Option longValue = userSettings.getLong(KEY_1);
        Assert.assertTrue((String)"there should be no long type", (boolean)longValue.isEmpty());
    }

    @Test
    public void typedStringUpdateStoresOnlyStringType() {
        this.userSettingsService.updateUserSettings(USERNAME, (Function)new Function<UserSettingsBuilder, UserSettings>(){

            public UserSettings apply(UserSettingsBuilder input) {
                input.put(UserSettingsTest.KEY_1, UserSettingsTest.STRING_VALUE);
                return input.build();
            }
        });
        UserSettings userSettings = this.userSettingsService.getUserSettings(USERNAME);
        Option stringValue = userSettings.getString(KEY_1);
        Assert.assertFalse((boolean)stringValue.isEmpty());
        Assert.assertEquals((Object)STRING_VALUE, (Object)stringValue.get());
        Option booleanValue = userSettings.getBoolean(KEY_1);
        Assert.assertTrue((boolean)booleanValue.isEmpty());
        Option longValue = userSettings.getLong(KEY_1);
        Assert.assertTrue((boolean)longValue.isEmpty());
    }

    @Test
    public void typedLongUpdateStoresOnlyLongType() {
        this.userSettingsService.updateUserSettings(USERNAME, (Function)new Function<UserSettingsBuilder, UserSettings>(){

            public UserSettings apply(UserSettingsBuilder input) {
                input.put(UserSettingsTest.KEY_1, 100L);
                return input.build();
            }
        });
        UserSettings userSettings = this.userSettingsService.getUserSettings(USERNAME);
        Option longValue = userSettings.getLong(KEY_1);
        Assert.assertFalse((boolean)longValue.isEmpty());
        Assert.assertEquals((long)100L, (long)((Long)longValue.get()));
        Option booleanValue = userSettings.getBoolean(KEY_1);
        Assert.assertTrue((boolean)booleanValue.isEmpty());
        Option stringValue = userSettings.getString(KEY_1);
        Assert.assertTrue((boolean)stringValue.isEmpty());
    }

    @Test
    public void updatingUserSettingsWithMaxLengthKeySucceeds() {
        this.userSettingsService.updateUserSettings(USERNAME, (Function)new Function<UserSettingsBuilder, UserSettings>(){

            public UserSettings apply(UserSettingsBuilder input) {
                input.put(MAX_LENGTH_KEY_STRING, true);
                return input.build();
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void updatingUserSettingsWithTooLongKeyFails() {
        this.userSettingsService.updateUserSettings(USERNAME, (Function)new Function<UserSettingsBuilder, UserSettings>(){

            public UserSettings apply(UserSettingsBuilder input) {
                input.put(TOO_LONG_STRING, true);
                return input.build();
            }
        });
    }

    @Test
    public void updatingUserSettingsWithMaxLengthStringValueSucceeds() {
        this.userSettingsService.updateUserSettings(USERNAME, (Function)new Function<UserSettingsBuilder, UserSettings>(){

            public UserSettings apply(UserSettingsBuilder input) {
                input.put(UserSettingsTest.KEY_1, MAX_LENGTH_VALUE_STRING);
                return input.build();
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void updatingUserSettingsWithTooLongStringValueFails() {
        this.userSettingsService.updateUserSettings(USERNAME, (Function)new Function<UserSettingsBuilder, UserSettings>(){

            public UserSettings apply(UserSettingsBuilder input) {
                input.put(UserSettingsTest.KEY_1, TOO_LONG_STRING);
                return input.build();
            }
        });
    }
}

