/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.refapp.ctk.AppSpecificInfoProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.security.Principal;
import org.junit.Assert;
import org.junit.Test;

public class UserManagerTest
extends SpringAwareTestCase {
    private UserManager userManager;
    private AppSpecificInfoProvider infoProvider;

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setInfoProvider(AppSpecificInfoProvider infoProvider) {
        this.infoProvider = infoProvider;
    }

    @Test
    public void testUserManager() {
        Assert.assertNotNull((String)"UserManager must be available to plugins", (Object)this.userManager);
    }

    @Test
    public void testNullRemoteUserWhileNotLoggedIn() {
        String remoteUsername = this.userManager.getRemoteUsername();
        Assert.assertTrue((String)("Should return null for username when not logged in. Currently logged user: " + remoteUsername), (remoteUsername == null ? 1 : 0) != 0);
    }

    @Test
    public void testAdminShouldBeAuthenticated() {
        Assert.assertTrue((String)"Should be able to login with admin/admin", (boolean)this.userManager.authenticate(this.infoProvider.getAdminUsername(), this.infoProvider.getAdminPassword()));
    }

    @Test
    public void testRandomUserShouldNotBeAuthenticated() {
        Assert.assertFalse((String)"Should not be able to login with random user/password", (boolean)this.userManager.authenticate("random user name wahaha", "random user password wahaha"));
    }

    @Test
    public void testAdminUserMustBeInAdminGroup() {
        Assert.assertTrue((String)"admin user should be sysadmin", (boolean)this.userManager.isSystemAdmin(this.infoProvider.getAdminUsername()));
    }

    @Test
    public void testAdminUserMustNotBeInRandomGroup() {
        Assert.assertFalse((String)"admin user should not be in a random dumb group name", (boolean)this.userManager.isUserInGroup(this.infoProvider.getAdminUsername(), "some_dumb_group_name_wahaha"));
    }

    @Test
    public void testRandomUserMustNotBeAdmin() {
        Assert.assertFalse((String)"some random user should not be sysadmin", (boolean)this.userManager.isSystemAdmin("some_random_dumb_user_blah_blah_wahaha"));
    }

    @Test
    public void testGetNonExistingProfileShouldReturnNull() {
        UserProfile nullProfile = this.userManager.getUserProfile("something_which_doesnt_exist");
        Assert.assertNull((String)"user which doesn't exist should result in null profile", (Object)nullProfile);
    }

    @Test
    public void testGetAdminProfileShouldNotBeNull() {
        UserProfile adminProfile = this.userManager.getUserProfile(this.infoProvider.getAdminUsername());
        Assert.assertNotNull((String)"admin profile should not be null", (Object)adminProfile);
    }

    @Test
    public void testGetAdminProfileShouldReturnValidProfile() {
        UserProfile adminProfile = this.userManager.getUserProfile(this.infoProvider.getAdminUsername());
        Assert.assertEquals((String)"admin profile should have appropriate admin username", (Object)this.infoProvider.getAdminUsername(), (Object)adminProfile.getUsername());
        Assert.assertEquals((String)"admin fullname should match", (Object)this.infoProvider.getAdminFullname(), (Object)adminProfile.getFullName());
        Assert.assertTrue((String)"this should return an email address", (boolean)adminProfile.getEmail().contains("@"));
    }

    @Test
    public void testResolveNotExistingUserShouldReturnNull() {
        Principal nullPrincipal = this.userManager.resolve("something_which_doesnt_exist");
        Assert.assertNull((String)"when the user doesn't exist, this must return null", (Object)nullPrincipal);
    }

    @Test
    public void testResolveAdminShouldReturnAdminPrinciple() {
        Principal adminPrincipal = this.userManager.resolve(this.infoProvider.getAdminUsername());
        Assert.assertNotNull((Object)adminPrincipal);
        Assert.assertEquals((Object)this.infoProvider.getAdminUsername(), (Object)adminPrincipal.getName());
    }
}

