/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.refapp.ctk.MockedUpgradeTask;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeManager;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class PluginUpgradeManagerTest
extends SpringAwareTestCase
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private PluginUpgradeManager upgradeManager;
    private PluginSettingsFactory pluginSettingsFactory;

    public void setUpgradeManager(PluginUpgradeManager upgradeManager) {
        this.upgradeManager = upgradeManager;
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Test
    public void testPluginUpgradeManagerAvailable() {
        Assert.assertNotNull((String)"PluginUpgradeManager should be available to plugins", (Object)this.upgradeManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeShouldBeCalledOnlyOnce() {
        MockedUpgradeTask upgradeTask = (MockedUpgradeTask)this.applicationContext.getBean("mockedUpgradeTask");
        this.pluginSettingsFactory.createGlobalSettings().remove(upgradeTask.getPluginKey() + ":build");
        upgradeTask.init();
        try {
            if (upgradeTask.getCalledCount() == 0) {
                this.upgradeManager.upgrade();
                Assert.assertTrue((String)"Upgrade task should have been called once since we have just called upgrade()", (upgradeTask.getCalledCount() == 1 ? 1 : 0) != 0);
            }
            this.upgradeManager.upgrade();
            Assert.assertTrue((String)"Upgrade task should not have been called again", (upgradeTask.getCalledCount() == 1 ? 1 : 0) != 0);
            this.pluginSettingsFactory.createGlobalSettings().remove(upgradeTask.getPluginKey() + ":build");
        }
        finally {
            upgradeTask.reset();
        }
    }
}

