/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.refapp.ctk.AppSpecificInfoProvider;
import com.atlassian.sal.api.license.LicenseHandler;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class LicenseHandlerTest
extends SpringAwareTestCase {
    static final String INVALID_LICENSE = StringUtils.repeat((String)"Helloworld ", (int)50);
    private AppSpecificInfoProvider infoProvider;
    private LicenseHandler handler;

    public void setHandler(LicenseHandler handler) {
        this.handler = handler;
    }

    public void setInfoProvider(AppSpecificInfoProvider infoProvider) {
        this.infoProvider = infoProvider;
    }

    @Test
    public void testLicenseHandlerAvailable() {
        Assert.assertNotNull((String)"License handler must be available to plugins", (Object)this.handler);
    }

    @Test
    public void testValidLicenseShouldNotThrowException() {
        this.handler.setLicense(this.infoProvider.getValidLicense());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidLicenseShouldthrowIAE() {
        this.handler.setLicense(INVALID_LICENSE);
    }

    @Test
    public void testGetServerIdReturnsValidID() {
        String acceptedFormat = "[A-Z0-9]{4}(-[A-Z0-9]{4}){3}";
        String serverId = this.handler.getServerId();
        Assert.assertTrue((String)("server id [" + serverId + "] does not conform to the format [" + acceptedFormat + "]"), (boolean)serverId.matches(acceptedFormat));
    }
}

