/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.sal.api.web.context.HttpContext;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.junit.Assert;
import org.junit.Test;

public class HttpContextTest
extends SpringAwareTestCase {
    private HttpContext httpContext;
    private ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory;

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void setThreadLocalDelegateExecutorFactory(ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        this.threadLocalDelegateExecutorFactory = threadLocalDelegateExecutorFactory;
    }

    @Test
    public void httpContextIsNonNullInRequestThread() {
        HttpServletRequest request = this.httpContext.getRequest();
        HttpServletResponse response = this.httpContext.getResponse();
        HttpSession session = this.httpContext.getSession(true);
        Assert.assertNotNull((String)"Request should be available from a HTTP thread", (Object)request);
        Assert.assertNotNull((String)"Response should be available from a HTTP thread", (Object)response);
        Assert.assertNotNull((String)"Session should be available from a HTTP thread", (Object)session);
        Assert.assertEquals((String)"Session from context should not change", (Object)session.getId(), (Object)this.httpContext.getSession(false).getId());
        Assert.assertEquals((String)"Session from request should not change", (Object)session.getId(), (Object)request.getSession(false).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void httpContextIsNullInExecutorThread() throws ExecutionException, InterruptedException {
        ExecutorService executorService = this.threadLocalDelegateExecutorFactory.createExecutorService(Executors.newSingleThreadExecutor());
        try {
            Future<HttpServletRequest> request = executorService.submit(new Callable<HttpServletRequest>(){

                @Override
                public HttpServletRequest call() throws Exception {
                    return HttpContextTest.this.httpContext.getRequest();
                }
            });
            Future<HttpServletResponse> response = executorService.submit(new Callable<HttpServletResponse>(){

                @Override
                public HttpServletResponse call() throws Exception {
                    return HttpContextTest.this.httpContext.getResponse();
                }
            });
            Future<HttpSession> sessionGet = executorService.submit(new Callable<HttpSession>(){

                @Override
                public HttpSession call() throws Exception {
                    return HttpContextTest.this.httpContext.getSession(false);
                }
            });
            Future<HttpSession> sessionCreate = executorService.submit(new Callable<HttpSession>(){

                @Override
                public HttpSession call() throws Exception {
                    return HttpContextTest.this.httpContext.getSession(false);
                }
            });
            Assert.assertNull((String)"Request should not be available from a worker thread", (Object)request.get());
            Assert.assertNull((String)"Response should not be available from a worker thread", (Object)response.get());
            Assert.assertNull((String)"Session should not be available from a worker thread", (Object)sessionGet.get());
            Assert.assertNull((String)"Session should not be creatable from a worker thread", (Object)sessionCreate.get());
        }
        finally {
            executorService.shutdown();
            executorService.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }
}

