/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.auth.AuthenticationController;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AuthenticationControllerTest
extends SpringAwareTestCase {
    private AuthenticationController controller;

    public void setController(AuthenticationController controller) {
        this.controller = controller;
    }

    @Test
    public void testAuthenticationControllerAvailable() {
        Assert.assertNotNull((String)"AuthenticationController should be available to plugins", (Object)this.controller);
    }

    @Test
    public void testShouldAttemptAuthenticationWhenRequestUnauthenticated() {
        Assert.assertTrue((String)"should return true if not authenticated", (boolean)this.controller.shouldAttemptAuthentication(this.createMockUnauthenticatedRequest()));
    }

    @Test
    public void testShouldNotAttemptAuthenticationWhenRequestAlreadyAuthenticated() {
        Assert.assertFalse((String)"should return false if already authenticated", (boolean)this.controller.shouldAttemptAuthentication(this.createMockAuthenticatedRequest("hoho")));
    }

    private HttpServletRequest createMockRequest() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)request.getServerName()).thenReturn((Object)"example.com");
        Mockito.when((Object)request.getServerPort()).thenReturn((Object)8080);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/context");
        return request;
    }

    private HttpServletRequest createMockUnauthenticatedRequest() {
        HttpServletRequest request = this.createMockRequest();
        Mockito.when((Object)request.getUserPrincipal()).thenReturn(null);
        return request;
    }

    private HttpServletRequest createMockAuthenticatedRequest(String authenticatedUserName) {
        HttpServletRequest request = this.createMockRequest();
        Mockito.when((Object)request.getUserPrincipal()).thenReturn((Object)new DummyPrincipal(authenticatedUserName));
        Mockito.when((Object)request.getAttribute("os_authstatus")).thenReturn((Object)"success");
        return request;
    }

    private static class DummyPrincipal
    implements Principal {
        private String name;

        private DummyPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

