/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Assert;
import org.junit.Test;

public class ApplicationPropertiesTest
extends SpringAwareTestCase {
    private ApplicationProperties appProp;

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.appProp = applicationProperties;
    }

    @Test
    public void testApplicationPropertiesAvailable() {
        Assert.assertNotNull((String)"ApplicationProperties should be available to plugins", (Object)this.appProp);
    }

    @Test
    public void testGetBuildDateNotNull() {
        Assert.assertNotNull((Object)this.appProp.getBuildDate());
    }

    @Test
    public void testGetBuildNumberNotNull() {
        Assert.assertNotNull((Object)this.appProp.getBuildNumber());
    }

    @Test
    public void testGetDisplayNameNotNull() {
        Assert.assertNotNull((Object)this.appProp.getDisplayName());
    }

    @Test
    public void testGetVersionNotNull() {
        Assert.assertNotNull((Object)this.appProp.getVersion());
    }

    @Test
    public void testGetBaseUrlNotNull() {
        Assert.assertNotNull((Object)this.appProp.getBaseUrl());
    }

    @Test
    public void testGetBaseUrlAccessible() throws IOException {
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod(this.appProp.getBaseUrl());
        Assert.assertEquals((String)"the base url must be accessible", (long)Response.Status.OK.getStatusCode(), (long)client.executeMethod((HttpMethod)get));
    }

    @Test
    public void testGetHomeDirectoryNotNull() {
        Assert.assertNotNull((Object)this.appProp.getHomeDirectory());
    }

    @Test
    public void testHomeDirectoryMustExist() {
        Assert.assertTrue((String)"the home directory must exist", (boolean)this.appProp.getHomeDirectory().exists());
        Assert.assertTrue((String)"it must be a directory", (boolean)this.appProp.getHomeDirectory().isDirectory());
    }
}

