/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class VersionStringComparator {
    private static final VersionStringComparator VERSION_COMPARATOR = new VersionStringComparator();
    private static final Pattern MODIFIER_PATTERN = Pattern.compile("([a-zA-Z]+)([0-9]*)");

    private int compare(String version1, String version2) {
        String thisVersion = "0";
        if (StringUtils.isNotEmpty((String)version1)) {
            thisVersion = version1.replaceAll(" ", "");
        }
        String compareVersion = "0";
        if (StringUtils.isNotEmpty((String)version2)) {
            compareVersion = version2.replaceAll(" ", "");
        }
        String[] v1 = StringUtils.split((String)thisVersion, (char)'.');
        String[] v2 = StringUtils.split((String)compareVersion, (char)'.');
        VersionStringComponentComparator componentComparator = new VersionStringComponentComparator();
        for (int i = 0; i < (v1.length > v2.length ? v1.length : v2.length); ++i) {
            String component2;
            String component1 = i >= v1.length ? "0" : v1[i];
            String string = component2 = i >= v2.length ? "0" : v2[i];
            if (componentComparator.compare(component1, component2) == 0) continue;
            return componentComparator.compare(component1, component2);
        }
        return 0;
    }

    public static boolean isSameOrNewerVersion(String specVersion, String actualVersion) {
        return VERSION_COMPARATOR.compare(specVersion, actualVersion) <= 0;
    }

    private class VersionStringComponentComparator
    implements Comparator<String> {
        public static final int FIRST_GREATER = 1;
        public static final int SECOND_GREATER = -1;

        private VersionStringComponentComparator() {
        }

        @Override
        public int compare(String component1, String component2) {
            if (component1.equalsIgnoreCase(component2)) {
                return 0;
            }
            if (StringUtils.isNumeric((String)component1) && StringUtils.isNumeric((String)component2)) {
                if (Integer.parseInt(component1) > Integer.parseInt(component2)) {
                    return 1;
                }
                if (Integer.parseInt(component2) > Integer.parseInt(component1)) {
                    return -1;
                }
                return 0;
            }
            if (StringUtils.isNumeric((String)component1)) {
                return 1;
            }
            if (StringUtils.isNumeric((String)component2)) {
                return -1;
            }
            Matcher matcherComponent1 = MODIFIER_PATTERN.matcher(component1);
            Matcher matcherComponent2 = MODIFIER_PATTERN.matcher(component2);
            if (!matcherComponent1.matches()) {
                throw new IllegalArgumentException("modifier not in supported format " + MODIFIER_PATTERN + " : " + component1);
            }
            if (!matcherComponent2.matches()) {
                throw new IllegalArgumentException("modifier not in supported format " + MODIFIER_PATTERN + " : " + component2);
            }
            int alphaCompareResult = matcherComponent1.group(1).compareToIgnoreCase(matcherComponent2.group(1));
            if (alphaCompareResult != 0) {
                return alphaCompareResult;
            }
            int numeric1 = StringUtils.isEmpty((String)matcherComponent1.group(2)) ? 0 : Integer.parseInt(matcherComponent1.group(2));
            int numeric2 = StringUtils.isEmpty((String)matcherComponent2.group(2)) ? 0 : Integer.parseInt(matcherComponent2.group(2));
            return new Integer(numeric1).compareTo(numeric2);
        }
    }
}

