package com.atlassian.refapp.ctk.sal;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.auth.LoginUriProvider;

import org.junit.Test;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

public class LoginUriProviderTest extends SpringAwareTestCase
{
    private LoginUriProvider provider;

    public void setProvider(LoginUriProvider provider)
    {
        this.provider = provider;
    }

    @Test
    public void testLoginUriProviderAvailable()
    {
        assertNotNull("LoginUriProvider should be available to plugins", provider);
    }

    public static void assertThatDestinationUriIsEncodedAsLoginUriQueryParameterValue(String destUri, URI loginUri)
    {
        String query = loginUri.getRawQuery();

        assertNotNull(query);

        Collection<String> allValues = new ArrayList<String>();

        for (String q : query.split("&"))
        {
            int i = q.indexOf('=');
            if (i >= 0)
            {
                String encodedVal = q.substring(i + 1);
                try
                {
                    String val = URLDecoder.decode(encodedVal, "utf-8");
                    allValues.add(val);
                }
                catch (UnsupportedEncodingException e)
                {
                    throw new RuntimeException(e);
                }
            }
        }

        // No Hamcrest in CTK environment; not worth fixing for one test.
//        assertThat("Login URI should contain destination",
//                allValues,
//                JUnitMatchers.hasItem(destUri));

        assertTrue("Login URI should contain destination: " + destUri + " should be in " + allValues,
                allValues.contains(destUri));
    }

    @Test
    public void testGetLoginUriMustContainDestinationUriAsParameterValue() throws URISyntaxException, UnsupportedEncodingException
    {
        String destUri = "http://server/dest.html?param=value";
        URI loginUri = provider.getLoginUri(new URI(destUri));

        assertThatDestinationUriIsEncodedAsLoginUriQueryParameterValue(destUri, loginUri);
    }

    @Test
    public void testGetLoginUriMustContainDestinationUriWithAmpersandAsParameterValue() throws URISyntaxException, UnsupportedEncodingException
    {
        String destUri = "http://server/dest.html?param=value&p2=val2";
        URI loginUri = provider.getLoginUri(new URI(destUri));

        assertThatDestinationUriIsEncodedAsLoginUriQueryParameterValue(destUri, loginUri);
    }
}
