package com.atlassian.refapp.ctk.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.sun.jersey.spi.resource.Singleton;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/**
 * Dummy REST resource which is protected by WebSudo.
 */
@Consumes({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
@Singleton
@AnonymousAllowed
@WebSudoRequired
@Path("/protecteddummy")
public class WebSudoProtectedResource
{
    @GET
    @Path("hello")
    public Response getHelloWorld()
    {
        return Response.ok("hello").build();
    }
}
