/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl.webresource;

import com.atlassian.cache.CacheFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.refimpl.ContainerManager;
import com.atlassian.plugin.refimpl.ParameterUtils;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;

public class SimpleWebResourceIntegration
implements WebResourceIntegration {
    private final String systemBuildNumber;
    private final LocaleResolver localeResolver;
    private final I18nResolver i18nResolver;
    private final CacheFactory cacheFactory;
    private final PluginEventManager eventManager;
    private final ThreadLocal<Map<String, Object>> requestCache = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    public SimpleWebResourceIntegration(ServletContext servletContext, LocaleResolver localeResolver, I18nResolver i18nResolver, CacheFactory cacheFactory, PluginEventManager eventManager) {
        this.systemBuildNumber = String.valueOf(System.currentTimeMillis());
        this.localeResolver = localeResolver;
        this.i18nResolver = i18nResolver;
        this.cacheFactory = cacheFactory;
        this.eventManager = eventManager;
    }

    public Locale getLocale() {
        return this.localeResolver.getLocale();
    }

    public String getI18nText(Locale locale, String s) {
        return this.i18nResolver.getText(locale, s);
    }

    public String getI18nRawText(Locale locale, String s) {
        return this.i18nResolver.getRawText(locale, s);
    }

    public CDNStrategy getCDNStrategy() {
        return null;
    }

    public String getBaseUrl() {
        return this.getBaseUrl(UrlMode.AUTO);
    }

    public String getBaseUrl(UrlMode urlMode) {
        String baseUrl = ParameterUtils.getBaseUrl(urlMode);
        return "/".equals(baseUrl) ? "" : baseUrl;
    }

    public PluginAccessor getPluginAccessor() {
        return ContainerManager.getInstance().getPluginAccessor();
    }

    public Map<String, Object> getRequestCache() {
        return this.requestCache.get();
    }

    public String getSystemBuildNumber() {
        return this.systemBuildNumber;
    }

    public String getSystemCounter() {
        return "1";
    }

    public String getSuperBatchVersion() {
        return "1";
    }

    public String getStaticResourceLocale() {
        return this.getLocale().toString();
    }

    public File getTemporaryDirectory() {
        String tempDir = System.getProperty("java.io.tmpdir");
        return new File(tempDir);
    }

    public Map<String, String> getResourceSubstitutionVariables() {
        String pdl = System.getProperty("pdl.dir", "");
        if (pdl.length() > 0 && !pdl.endsWith("/")) {
            pdl = pdl + "/";
        }
        return ImmutableMap.of((Object)"pdl.dir", (Object)pdl);
    }

    public PluginEventManager getPluginEventManager() {
        return this.eventManager;
    }

    public CacheFactory getCacheFactory() {
        return this.cacheFactory;
    }

    public Set<String> allowedCondition1Keys() {
        return null;
    }

    public Set<String> allowedTransform1Keys() {
        return null;
    }

    public boolean forbidCondition1AndTransformer1() {
        return false;
    }
}

