/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl.webresource;

import com.atlassian.plugin.refimpl.CurrentHttpRequest;
import com.atlassian.plugin.webresource.DefaultResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class RefAppResourceBatchingConfiguration
extends DefaultResourceBatchingConfiguration
implements ResourceBatchingConfiguration {
    private static String SUPER_BATCH_FOR = System.getProperty("super.batch.for");
    private static final boolean DEV_MODE = Boolean.getBoolean("atlassian.dev.mode");
    private static final List<String> resources = ImmutableList.of((Object)"com.atlassian.refapp.amd:amd", (Object)"com.atlassian.auiplugin:ajs");

    public boolean isSuperBatchingEnabled() {
        return this.forceBatchingInThisRequest();
    }

    public List<String> getSuperBatchModuleCompleteKeys() {
        return resources;
    }

    public boolean isContextBatchingEnabled() {
        return !DEV_MODE;
    }

    public boolean isPluginWebResourceBatchingEnabled() {
        return !DEV_MODE || this.forceBatchingInThisRequest();
    }

    private boolean forceBatchingInThisRequest() {
        if ("all".equalsIgnoreCase(SUPER_BATCH_FOR)) {
            return true;
        }
        if ("ie".equalsIgnoreCase(SUPER_BATCH_FOR)) {
            HttpServletRequest httpRequest = CurrentHttpRequest.getRequest();
            if (httpRequest == null) {
                return false;
            }
            String userAgent = httpRequest.getHeader("USER-AGENT");
            if (userAgent != null) {
                return userAgent.contains("Trident");
            }
        }
        return false;
    }
}

