/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl.tenant;

import com.atlassian.plugin.refimpl.tenant.RefappTenant;
import com.atlassian.plugin.refimpl.tenant.RefappTenantRegistry;
import com.atlassian.plugins.landlord.spi.LandlordRequestException;
import com.atlassian.plugins.landlord.spi.LandlordRequests;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RefappLandlordRequests
implements LandlordRequests {
    private SettableFuture<Void> tenantTrigger;
    private RefappTenantRegistry tenantRegistry;

    public RefappLandlordRequests(SettableFuture<Void> tenantTrigger, RefappTenantRegistry tenantRegistry) {
        this.tenantTrigger = tenantTrigger;
        this.tenantRegistry = tenantRegistry;
    }

    public void acceptTenant(String tenantId) throws LandlordRequestException {
        this.acceptTenant(tenantId, Collections.<String, String>emptyMap());
    }

    public void acceptTenant(String tenantId, Map<String, String> tenantProperties) throws LandlordRequestException {
        this.tenantTrigger.set(null);
        this.tenantRegistry.setTenant(new RefappTenant(tenantId));
    }

    public void removeTenant(String tenantId) throws LandlordRequestException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<String> getTenants() {
        ArrayList<String> tenantIDs = new ArrayList<String>();
        for (RefappTenant tenant : this.tenantRegistry.getRefappTenants()) {
            tenantIDs.add(tenant.getTenantID());
        }
        return tenantIDs;
    }
}

