/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl.saldeps;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.refimpl.saldeps.DefaultMessage;
import com.atlassian.plugin.refimpl.saldeps.DefaultMessageCollection;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.message.MessageCollection;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;

public class CoreRefimplI18nResolver
implements I18nResolver {
    private ManagedLock.ReadWrite locks = ManagedLocks.manageReadWrite((ReadWriteLock)new ReentrantReadWriteLock());
    private final Map<Plugin, Iterable<String>> pluginResourceBundleNames = new ConcurrentHashMap<Plugin, Iterable<String>>();
    private static final Serializable[] EMPTY_SERIALIZABLE = new Serializable[0];

    public CoreRefimplI18nResolver(final PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        pluginEventManager.register((Object)this);
        this.locks.write().withLock(new Runnable(){

            @Override
            public void run() {
                CoreRefimplI18nResolver.this.addPluginResourceBundles(pluginAccessor.getPlugins());
            }
        });
    }

    public String getText(String key, Serializable ... arguments) {
        Serializable[] resolvedArguments = new Serializable[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Serializable argument = arguments[i];
            resolvedArguments[i] = argument instanceof Message ? this.getText((Message)argument) : arguments[i];
        }
        return this.resolveText(key, resolvedArguments);
    }

    public String getText(Locale locale, String key, Serializable ... arguments) {
        Preconditions.checkNotNull((Object)locale);
        Serializable[] resolvedArguments = new Serializable[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Serializable argument = arguments[i];
            resolvedArguments[i] = argument instanceof Message ? this.getText(locale, (Message)argument) : arguments[i];
        }
        return this.resolveText(locale, key, resolvedArguments);
    }

    public String getText(String key) {
        return this.resolveText(key, EMPTY_SERIALIZABLE);
    }

    public String getText(Locale locale, String key) {
        Preconditions.checkNotNull((Object)locale);
        return this.resolveText(locale, key, EMPTY_SERIALIZABLE);
    }

    public String getText(Message message) {
        return this.getText(message.getKey(), message.getArguments());
    }

    public String getText(Locale locale, Message message) {
        return this.getText(locale, message.getKey(), message.getArguments());
    }

    public Message createMessage(String key, Serializable ... arguments) {
        return new DefaultMessage(key, arguments);
    }

    public MessageCollection createMessageCollection() {
        return new DefaultMessageCollection();
    }

    public String getRawText(String key) {
        return StringUtils.defaultString((String)this.getPattern(Locale.getDefault(), key), (String)key);
    }

    public String getRawText(Locale locale, String key) {
        return StringUtils.defaultString((String)this.getPattern(locale, key), (String)key);
    }

    public String resolveText(String key, Serializable[] arguments) {
        String pattern = this.getPattern(Locale.getDefault(), key);
        if (pattern == null) {
            return key;
        }
        return MessageFormat.format(pattern, arguments);
    }

    public String resolveText(Locale locale, String key, Serializable[] arguments) {
        String pattern = StringUtils.defaultString((String)this.getPattern(locale, key), (String)this.getPattern(Locale.getDefault(), key));
        if (pattern == null) {
            return key;
        }
        return MessageFormat.format(pattern, arguments);
    }

    private String getPattern(final Locale locale, final String key) {
        return (String)this.locks.read().withLock((Supplier)new Supplier<String>(){

            public String get() {
                String bundleString = null;
                for (Map.Entry pluginBundleNames : CoreRefimplI18nResolver.this.pluginResourceBundleNames.entrySet()) {
                    for (String bundleName : (Iterable)pluginBundleNames.getValue()) {
                        try {
                            ResourceBundle bundle = CoreRefimplI18nResolver.this.getBundle(bundleName, locale, (Plugin)pluginBundleNames.getKey());
                            bundleString = bundle.getString(key);
                        }
                        catch (MissingResourceException missingResourceException) {}
                    }
                }
                return bundleString;
            }
        });
    }

    public Map<String, String> getAllTranslationsForPrefix(final String prefix) {
        CoreRefimplI18nResolver.assertNotNull(prefix, "prefix");
        return (Map)this.locks.read().withLock((Supplier)new Supplier<Map<String, String>>(){

            public Map<String, String> get() {
                HashMap<String, String> translationsWithPrefix = new HashMap<String, String>();
                for (Map.Entry pluginBundleNames : CoreRefimplI18nResolver.this.pluginResourceBundleNames.entrySet()) {
                    CoreRefimplI18nResolver.this.addMatchingTranslationsToMap(prefix, Locale.getDefault(), (Plugin)pluginBundleNames.getKey(), (Iterable)pluginBundleNames.getValue(), translationsWithPrefix);
                }
                return translationsWithPrefix;
            }
        });
    }

    public Map<String, String> getAllTranslationsForPrefix(final String prefix, final Locale locale) {
        CoreRefimplI18nResolver.assertNotNull(prefix, "prefix");
        CoreRefimplI18nResolver.assertNotNull(locale, "locale");
        return (Map)this.locks.read().withLock((Supplier)new Supplier<Map<String, String>>(){

            public Map<String, String> get() {
                HashMap<String, String> translationsWithPrefix = new HashMap<String, String>();
                for (Map.Entry pluginBundleNames : CoreRefimplI18nResolver.this.pluginResourceBundleNames.entrySet()) {
                    CoreRefimplI18nResolver.this.addMatchingTranslationsToMap(prefix, locale, (Plugin)pluginBundleNames.getKey(), (Iterable)pluginBundleNames.getValue(), translationsWithPrefix);
                }
                return translationsWithPrefix;
            }
        });
    }

    private void addMatchingTranslationsToMap(String prefix, Locale locale, Plugin plugin, Iterable<String> bundleNames, Map<String, String> translationsWithPrefix) {
        for (String bundleName : bundleNames) {
            try {
                ResourceBundle bundle = this.getBundle(bundleName, locale, plugin);
                if (bundle == null) continue;
                this.addMatchingTranslationsToMap(prefix, bundle, translationsWithPrefix);
            }
            catch (MissingResourceException missingResourceException) {}
        }
    }

    private void addMatchingTranslationsToMap(String prefix, ResourceBundle bundle, Map<String, String> translationsWithPrefix) {
        Enumeration<String> enumeration = bundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            if (!key.startsWith(prefix)) continue;
            translationsWithPrefix.put(key, bundle.getString(key));
        }
    }

    @PluginEventListener
    public void pluginEnabled(final PluginEnabledEvent event) {
        this.locks.write().withLock(new Runnable(){

            @Override
            public void run() {
                CoreRefimplI18nResolver.this.addPluginResourceBundles(event.getPlugin());
            }
        });
    }

    @PluginEventListener
    public void pluginDisabled(final PluginDisabledEvent event) {
        this.locks.write().withLock(new Runnable(){

            @Override
            public void run() {
                CoreRefimplI18nResolver.this.removePluginResourceBundles(event.getPlugin());
            }
        });
    }

    private void addPluginResourceBundles(Iterable<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            this.addPluginResourceBundles(plugin);
        }
    }

    private void addPluginResourceBundles(Plugin plugin) {
        LinkedList<String> bundleNames = new LinkedList<String>();
        List descriptors = plugin.getResourceDescriptors("i18n");
        for (ResourceDescriptor descriptor : descriptors) {
            bundleNames.add(descriptor.getLocation());
        }
        this.addPluginResourceBundles(plugin, bundleNames);
    }

    private void addPluginResourceBundles(Plugin plugin, List<String> bundleNames) {
        this.pluginResourceBundleNames.put(plugin, bundleNames);
    }

    private void removePluginResourceBundles(Plugin plugin) {
        this.pluginResourceBundleNames.remove(plugin);
    }

    private ResourceBundle getBundle(String bundleName, Locale locale, Plugin plugin) {
        return ResourceBundle.getBundle(bundleName, locale, plugin.getClassLoader());
    }

    private static <T> T assertNotNull(T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null");
        }
        return object;
    }
}

