/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl.db;

import com.atlassian.refapp.api.ConnectionProvider;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.h2.tools.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionProviderImpl
implements ConnectionProvider {
    private static final Logger LOG;
    private static final String DB_DIR;
    private static final String DB_USERNAME = "sa";
    private static final String LOCAL_HOST;
    private static String url;

    public Connection connection() throws SQLException {
        return DriverManager.getConnection(url, DB_USERNAME, "");
    }

    static {
        int port;
        LOG = LoggerFactory.getLogger(ConnectionProviderImpl.class);
        DB_DIR = System.getProperty("refapp.home", System.getProperty("java.io.tmpdir"));
        LOCAL_HOST = InetAddress.getLoopbackAddress().getHostAddress();
        try {
            Server server = Server.createTcpServer((String[])new String[0]);
            System.setProperty("h2.bindAddress", LOCAL_HOST);
            server.start();
            port = server.getPort();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        url = "jdbc:h2:tcp://" + LOCAL_HOST + ":" + port + "/" + DB_DIR + "/h2db";
        LOG.info("started database '{}', username '{}', no password", (Object)url, (Object)DB_USERNAME);
    }
}

