/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl.webresource;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.refimpl.ContainerManager;
import com.atlassian.plugin.refimpl.ParameterUtils;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;

public class SimpleWebResourceIntegration
implements WebResourceIntegration {
    private final String systemBuildNumber;
    private final ThreadLocal<Map<String, Object>> requestCache = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    public SimpleWebResourceIntegration(ServletContext servletContext) {
        this.systemBuildNumber = String.valueOf(System.currentTimeMillis());
    }

    public String getBaseUrl() {
        return this.getBaseUrl(UrlMode.AUTO);
    }

    public String getBaseUrl(UrlMode urlMode) {
        return ParameterUtils.getBaseUrl(urlMode);
    }

    public PluginAccessor getPluginAccessor() {
        return ContainerManager.getInstance().getPluginAccessor();
    }

    public Map<String, Object> getRequestCache() {
        return this.requestCache.get();
    }

    public String getSystemBuildNumber() {
        return this.systemBuildNumber;
    }

    public String getSystemCounter() {
        return "1";
    }

    public String getSuperBatchVersion() {
        return "1";
    }

    public String getStaticResourceLocale() {
        return null;
    }

    public File getTemporaryDirectory() {
        String tempDir = System.getProperty("java.io.tmpdir");
        return new File(tempDir);
    }

    public Map<String, String> getResourceSubstitutionVariables() {
        String pdl = System.getProperty("pdl.dir", "");
        if (pdl.length() > 0 && !pdl.endsWith("/")) {
            pdl = pdl + "/";
        }
        return ImmutableMap.of((Object)"pdl.dir", (Object)pdl);
    }
}

