/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl.tenant;

import com.atlassian.plugin.refimpl.tenant.RefappTenant;
import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantAccessor;
import com.atlassian.tenancy.api.TenantContext;
import com.atlassian.tenancy.api.TenantUnavailableException;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class RefappTenantRegistry
implements TenantAccessor,
TenantContext {
    private RefappTenant tenant;

    public Iterable<Tenant> getAvailableTenants() {
        if (this.tenant != null) {
            ArrayList<Tenant> list = new ArrayList<Tenant>();
            list.add(this.tenant);
            return list;
        }
        return new ArrayList<Tenant>();
    }

    public List<RefappTenant> getRefappTenants() {
        ArrayList<RefappTenant> list = new ArrayList<RefappTenant>();
        if (this.tenant != null) {
            list.add(this.tenant);
        }
        return list;
    }

    public void setTenant(RefappTenant tenant) {
        this.tenant = tenant;
    }

    public boolean hasTenant() {
        return this.tenant != null;
    }

    @Nullable
    public Tenant getCurrentTenant() {
        return this.tenant;
    }

    public <T> T asTenant(Tenant tenant, Callable<T> callback) throws TenantUnavailableException, InvocationTargetException {
        Preconditions.checkNotNull((Object)tenant);
        Preconditions.checkNotNull(callback);
        if (tenant != this.tenant) {
            throw new TenantUnavailableException();
        }
        try {
            return callback.call();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }
}

