/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl.tenant;

import com.atlassian.plugin.refimpl.ParameterUtils;
import com.atlassian.plugin.refimpl.tenant.RefappLandlordRequests;
import com.atlassian.plugin.refimpl.tenant.RefappTenancyCondition;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugins.landlord.spi.LandlordRequestException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefappTenancyManager {
    private static final Logger log = LoggerFactory.getLogger(RefappTenancyManager.class);
    private final RefappLandlordRequests landlordRequests;

    public RefappTenancyManager(RefappLandlordRequests landlordRequests) {
        this.landlordRequests = landlordRequests;
    }

    public void enableTenancy() {
        if (!RefappTenancyCondition.isEnabled()) {
            String tenantId = this.getBaseUrlWithoutProtocol(ParameterUtils.getBaseUrl(UrlMode.ABSOLUTE));
            try {
                this.landlordRequests.acceptTenant(tenantId);
            }
            catch (LandlordRequestException elr) {
                log.error("Unable to accept tenant", (Throwable)elr);
            }
        }
    }

    private String getBaseUrlWithoutProtocol(String baseUrl) {
        try {
            URL url = new URL(baseUrl);
            return url.getAuthority() + url.getPath();
        }
        catch (Exception e) {
            log.warn("Could not remove url protocol from '{}' : {}", (Object)baseUrl, (Object)e.getMessage());
            return baseUrl;
        }
    }
}

