/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl.filter;

import com.atlassian.plugin.refimpl.tenant.RefappTenancyCondition;
import com.atlassian.plugin.refimpl.tenant.RefappTenantRegistry;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RefAppTenantFilter
implements Filter {
    private ServletContext context;
    private RefappTenantRegistry tenantRegistry;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        this.tenantRegistry = (RefappTenantRegistry)this.context.getAttribute("tenantAccessor");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (RefappTenancyCondition.isEnabled()) {
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            String path = req.getRequestURI();
            if (this.isBaseRest(path) || this.tenantRegistry.hasTenant()) {
                filterChain.doFilter(servletRequest, servletResponse);
            } else {
                ((HttpServletResponse)servletResponse).sendError(202, "Server unavailable. Waiting for tenant.");
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }

    public boolean isBaseRest(String path) {
        String contextpath = this.context.getContextPath();
        return path.startsWith("/refapp/rest/landlord") || path.startsWith("/refapp/plugins/servlet/landlord");
    }
}

