/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class SystemExportVersionUtils {
    private static final String GUAVA_PROPERTY_PATH = "META-INF/maven/com.google.guava/guava/pom.properties";

    private SystemExportVersionUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGoogleGuavaVersion() {
        String string;
        InputStream inputStream = null;
        try {
            inputStream = SystemExportVersionUtils.class.getClassLoader().getResourceAsStream(GUAVA_PROPERTY_PATH);
            if (inputStream == null) {
                throw new IllegalStateException("google guava is required in classpath for refapp to function");
            }
            Properties props = new Properties();
            try {
                props.load(inputStream);
            }
            catch (IOException e) {
                throw new IllegalStateException("cannot read the bundled google guava version file");
            }
            String guavaVersion = props.getProperty("version");
            if (guavaVersion == null) {
                throw new IllegalStateException("cannot extract google guava version from the bundled version file");
            }
            string = guavaVersion;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return string;
    }
}

