/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.beehive.SimpleClusterLockService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Application;
import com.atlassian.plugin.DefaultModuleDescriptorFactory;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.SplitStartupPluginSystemLifecycle;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.hostcontainer.SimpleConstructorHostContainer;
import com.atlassian.plugin.main.AtlassianPlugins;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.main.PluginsConfigurationBuilder;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.metadata.DefaultPluginMetadataManager;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.module.ClassPrefixModuleFactory;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.module.PrefixDelegatingModuleFactory;
import com.atlassian.plugin.module.PrefixModuleFactory;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.impl.DefaultPackageScannerConfiguration;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.plugin.osgi.module.BeanPrefixModuleFactory;
import com.atlassian.plugin.refimpl.ConfigParser;
import com.atlassian.plugin.refimpl.DefaultPluginPersistentStateStore;
import com.atlassian.plugin.refimpl.SystemExportVersionUtils;
import com.atlassian.plugin.refimpl.servlet.SimpleContentTypeResolver;
import com.atlassian.plugin.refimpl.servlet.SimpleServletContextFactory;
import com.atlassian.plugin.refimpl.tenant.RefappLandlordRequests;
import com.atlassian.plugin.refimpl.tenant.RefappTenancyManager;
import com.atlassian.plugin.refimpl.tenant.RefappTenantRegistry;
import com.atlassian.plugin.refimpl.webresource.RefAppResourceBatchingConfiguration;
import com.atlassian.plugin.refimpl.webresource.SimpleWebResourceIntegration;
import com.atlassian.plugin.schema.descriptor.DescribedModuleDescriptorFactory;
import com.atlassian.plugin.schema.impl.DefaultDescribedModuleDescriptorFactory;
import com.atlassian.plugin.servlet.ContentTypeResolver;
import com.atlassian.plugin.servlet.DefaultServletModuleManager;
import com.atlassian.plugin.servlet.DownloadStrategy;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletContextListenerModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletContextParamModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletFilterModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.PluginResourceLocatorImpl;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceManagerImpl;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.WebResourceUrlProviderImpl;
import com.atlassian.plugin.webresource.servlet.PluginResourceDownload;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerModuleDescriptor;
import com.atlassian.plugins.landlord.spi.LandlordRequests;
import com.atlassian.tenancy.api.TenantAccessor;
import com.atlassian.tenancy.api.TenantContext;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ContainerManager {
    public static final String TENANTACCESSOR = "tenantAccessor";
    private static final String BUNDLED_PLUGINS_ZIP = "/atlassian-bundled-plugins.zip";
    private static final String PACKAGE_VERSION_EXPORT_OVERRIDES = "refapp.packageExport.overrides";
    private final ServletModuleManager servletModuleManager;
    private final SimpleWebResourceIntegration webResourceIntegration;
    private final WebResourceManager webResourceManager;
    private final OsgiContainerManager osgiContainerManager;
    private final PluginAccessor pluginAccessor;
    private final HostComponentProvider hostComponentProvider;
    private final DefaultModuleDescriptorFactory moduleDescriptorFactory;
    private final Map<Class<?>, Object> publicContainer;
    private final AtlassianPlugins plugins;
    private final SplitStartupPluginSystemLifecycle pluginLifecycle;
    private final RefappTenantRegistry tenantAccessor;
    private final RefappLandlordRequests landlordImpl;
    private final RefappTenancyManager tenancyManager;
    private final ClusterLockService clusterLockService;
    private final PluginPhaseTriggers triggers = new PluginPhaseTriggers();
    private final HostContainer hostContainer;
    private static ContainerManager instance;
    private final List<DownloadStrategy> downloadStrategies;

    public ContainerManager(ServletContext servletContext) {
        instance = this;
        try {
            Class<?> factoryFinder = Class.forName("javax.xml.transform.FactoryFinder");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.webResourceIntegration = new SimpleWebResourceIntegration(servletContext);
        WebResourceUrlProviderImpl webResourceUrlProvider = new WebResourceUrlProviderImpl((WebResourceIntegration)this.webResourceIntegration);
        HostContainer delegatingHostContainer = new HostContainer(){

            public <T> T create(Class<T> moduleClass) throws IllegalArgumentException {
                return (T)ContainerManager.this.hostContainer.create(moduleClass);
            }
        };
        this.moduleDescriptorFactory = new DefaultDescribedModuleDescriptorFactory(delegatingHostContainer);
        this.moduleDescriptorFactory.addModuleDescriptor("servlet", ServletModuleDescriptor.class);
        this.moduleDescriptorFactory.addModuleDescriptor("servlet-filter", ServletFilterModuleDescriptor.class);
        this.moduleDescriptorFactory.addModuleDescriptor("servlet-context-param", ServletContextParamModuleDescriptor.class);
        this.moduleDescriptorFactory.addModuleDescriptor("servlet-context-listener", ServletContextListenerModuleDescriptor.class);
        this.moduleDescriptorFactory.addModuleDescriptor("web-resource", WebResourceModuleDescriptor.class);
        this.moduleDescriptorFactory.addModuleDescriptor("web-resource-transformer", WebResourceTransformerModuleDescriptor.class);
        this.moduleDescriptorFactory.addModuleDescriptor("url-reading-web-resource-transformer", UrlReadingWebResourceTransformerModuleDescriptor.class);
        DefaultPackageScannerConfiguration scannerConfig = new DefaultPackageScannerConfiguration(this.determineVersion());
        scannerConfig.setServletContext(servletContext);
        ArrayList<String> packageIncludes = new ArrayList<String>(scannerConfig.getPackageIncludes());
        packageIncludes.add("org.bouncycastle*");
        packageIncludes.add("org.dom4j*");
        packageIncludes.add("javax.servlet*");
        packageIncludes.add("com.google.common.*");
        packageIncludes.add("com.atlassian.sal*");
        packageIncludes.add("com.opensymphony.module.sitemesh*");
        scannerConfig.setPackageIncludes(packageIncludes);
        scannerConfig.setPackageVersions((Map)ImmutableMap.builder().put((Object)"javax.servlet", (Object)"2.5").put((Object)"javax.servlet.http", (Object)"2.5").put((Object)"com.google.common.*", (Object)SystemExportVersionUtils.getGoogleGuavaVersion()).build());
        String packageVersionExportString = System.getProperty(PACKAGE_VERSION_EXPORT_OVERRIDES);
        if (packageVersionExportString != null) {
            scannerConfig.getPackageVersions().putAll(ConfigParser.parseMap(packageVersionExportString));
        }
        this.hostComponentProvider = new SimpleHostComponentProvider();
        File osgiCache = this.findAndCreateDirectory(servletContext, "osgi.cache", "WEB-INF/osgi-cache");
        File bundledPluginDir = this.findAndCreateDirectory(servletContext, "bundledplugins.cache", "WEB-INF/bundled-plugins");
        PluginsConfiguration config = new PluginsConfigurationBuilder().useLegacyDynamicPluginDeployer(true).bundledPluginUrl(this.getClass().getResource(BUNDLED_PLUGINS_ZIP)).bundledPluginCacheDirectory(bundledPluginDir).pluginDirectory(this.makeSureDirectoryExists(servletContext, "/WEB-INF/plugins")).moduleDescriptorFactory((ModuleDescriptorFactory)this.moduleDescriptorFactory).packageScannerConfiguration((PackageScannerConfiguration)scannerConfig).hostComponentProvider(this.hostComponentProvider).osgiPersistentCache(osgiCache).pluginStateStore((PluginPersistentStateStore)new DefaultPluginPersistentStateStore(osgiCache)).application(this.refapp()).build();
        PrefixDelegatingModuleFactory moduleFactory = new PrefixDelegatingModuleFactory((Set)ImmutableSet.of((Object)new BeanPrefixModuleFactory()));
        this.plugins = new AtlassianPlugins(config);
        PluginEventManager pluginEventManager = this.plugins.getPluginEventManager();
        this.osgiContainerManager = this.plugins.getOsgiContainerManager();
        this.servletModuleManager = new DefaultServletModuleManager(servletContext, pluginEventManager);
        this.pluginAccessor = this.plugins.getPluginAccessor();
        assert (this.plugins instanceof SplitStartupPluginSystemLifecycle);
        this.pluginLifecycle = (SplitStartupPluginSystemLifecycle)this.plugins.getPluginAccessor();
        RefAppResourceBatchingConfiguration refappBatchconfig = new RefAppResourceBatchingConfiguration();
        SimpleServletContextFactory simpleServletContextFactory = new SimpleServletContextFactory(servletContext);
        PluginResourceLocatorImpl pluginResourceLocator = new PluginResourceLocatorImpl((WebResourceIntegration)this.webResourceIntegration, (ServletContextFactory)simpleServletContextFactory, (WebResourceUrlProvider)webResourceUrlProvider, (ResourceBatchingConfiguration)refappBatchconfig, pluginEventManager);
        PluginResourceDownload pluginDownloadStrategy = new PluginResourceDownload((PluginResourceLocator)pluginResourceLocator, (ContentTypeResolver)new SimpleContentTypeResolver(), "UTF-8");
        this.webResourceManager = new WebResourceManagerImpl((PluginResourceLocator)pluginResourceLocator, (WebResourceIntegration)this.webResourceIntegration, (WebResourceUrlProvider)webResourceUrlProvider, (ResourceBatchingConfiguration)refappBatchconfig);
        EventPublisher eventPublisher = this.plugins.getEventPublisher();
        this.tenantAccessor = new RefappTenantRegistry();
        this.landlordImpl = new RefappLandlordRequests(this.triggers.getTenantTrigger(), this.tenantAccessor);
        this.tenancyManager = new RefappTenancyManager(this.landlordImpl);
        servletContext.setAttribute(TENANTACCESSOR, (Object)this.tenantAccessor);
        this.clusterLockService = new SimpleClusterLockService();
        this.publicContainer = new HashMap();
        this.publicContainer.put(PluginController.class, this.plugins.getPluginController());
        this.publicContainer.put(ClusterLockService.class, this.clusterLockService);
        this.publicContainer.put(SplitStartupPluginSystemLifecycle.class, this.pluginLifecycle);
        this.publicContainer.put(EventPublisher.class, eventPublisher);
        this.publicContainer.put(TenantAccessor.class, this.tenantAccessor);
        this.publicContainer.put(TenantContext.class, this.tenantAccessor);
        this.publicContainer.put(LandlordRequests.class, this.landlordImpl);
        this.publicContainer.put(ServletModuleManager.class, this.servletModuleManager);
        this.publicContainer.put(WebResourceManager.class, this.webResourceManager);
        this.publicContainer.put(WebResourceUrlProvider.class, webResourceUrlProvider);
        this.publicContainer.put(Map.class, this.publicContainer);
        this.publicContainer.put(ModuleFactory.class, moduleFactory);
        this.publicContainer.put(PluginMetadataManager.class, new DefaultPluginMetadataManager());
        this.publicContainer.put(ServletContextFactory.class, simpleServletContextFactory);
        this.publicContainer.put(ModuleDescriptorFactory.class, this.moduleDescriptorFactory);
        this.publicContainer.put(ListableModuleDescriptorFactory.class, this.moduleDescriptorFactory);
        this.publicContainer.put(DescribedModuleDescriptorFactory.class, this.moduleDescriptorFactory);
        this.publicContainer.put(TenantAccessor.class, this.tenantAccessor);
        this.hostContainer = new SimpleConstructorHostContainer(this.publicContainer);
        moduleFactory.addPrefixModuleFactory((PrefixModuleFactory)new ClassPrefixModuleFactory(this.hostContainer));
        try {
            this.pluginLifecycle.earlyStartup();
            this.triggers.getPhase1Trigger().set(null);
        }
        catch (PluginParseException e) {
            throw new RuntimeException(e);
        }
        this.tenancyManager.enableTenancy();
        this.downloadStrategies = new ArrayList<DownloadStrategy>();
        this.downloadStrategies.add((DownloadStrategy)pluginDownloadStrategy);
    }

    private Application refapp() {
        return new Application(){

            public String getKey() {
                return "refapp";
            }

            public String getVersion() {
                return "1.0";
            }

            public String getBuildNumber() {
                return "123";
            }
        };
    }

    private File findAndCreateDirectory(ServletContext servletContext, String sysPropName, String defaultPath) {
        File dir = System.getProperty(sysPropName) != null ? this.makeSureDirectoryExists(System.getProperty(sysPropName)) : this.makeSureDirectoryExists(servletContext, defaultPath);
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String determineVersion() {
        InputStream in;
        block4: {
            String string;
            in = null;
            Properties props = new Properties();
            try {
                in = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/com.atlassian.plugins/atlassian-plugins-core/pom.properties");
                if (in == null) break block4;
                props.load(in);
                string = props.getProperty("version");
            }
            catch (IOException e) {
                String string2;
                try {
                    e.printStackTrace();
                    string2 = null;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                return string2;
            }
            IOUtils.closeQuietly((InputStream)in);
            return string;
        }
        IOUtils.closeQuietly((InputStream)in);
        return null;
    }

    private File makeSureDirectoryExists(ServletContext servletContext, String relativePath) {
        return this.makeSureDirectoryExists(servletContext.getRealPath(relativePath));
    }

    private File makeSureDirectoryExists(String path) {
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Could not create directory <" + dir + ">");
        }
        return dir;
    }

    public static synchronized void setInstance(ContainerManager mgr) {
        instance = mgr;
    }

    public static synchronized ContainerManager getInstance() {
        return instance;
    }

    public ServletModuleManager getServletModuleManager() {
        return this.servletModuleManager;
    }

    public OsgiContainerManager getOsgiContainerManager() {
        return this.osgiContainerManager;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public HostComponentProvider getHostComponentProvider() {
        return this.hostComponentProvider;
    }

    public ModuleDescriptorFactory getModuleDescriptorFactory() {
        return this.moduleDescriptorFactory;
    }

    public List<DownloadStrategy> getDownloadStrategies() {
        return this.downloadStrategies;
    }

    public WebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }

    public WebResourceIntegration getWebResourceIntegration() {
        return this.webResourceIntegration;
    }

    void shutdown() {
        this.plugins.stop();
    }

    private class SimpleHostComponentProvider
    implements HostComponentProvider {
        private SimpleHostComponentProvider() {
        }

        public void provide(ComponentRegistrar componentRegistrar) {
            Assertions.notNull((String)"publicContainer", (Object)ContainerManager.this.publicContainer);
            for (Map.Entry entry : ContainerManager.this.publicContainer.entrySet()) {
                String name = StringUtils.uncapitalize((String)((Class)entry.getKey()).getSimpleName());
                componentRegistrar.register(new Class[]{(Class)entry.getKey()}).forInstance(entry.getValue()).withName(name);
            }
        }
    }

    private class PluginPhaseTriggers {
        private SettableFuture<Void> triggerPhase1 = SettableFuture.create();
        private SettableFuture<Void> triggerTenant = SettableFuture.create();
        private ListenableFuture<List<Void>> phase2ready = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{this.triggerPhase1, this.triggerTenant});

        public PluginPhaseTriggers() {
            Futures.addCallback(this.phase2ready, (FutureCallback)new FutureCallback<List<Void>>(){

                public void onSuccess(List<Void> results) {
                    ContainerManager.this.pluginLifecycle.lateStartup();
                }

                public void onFailure(Throwable throwable) {
                }
            });
        }

        public SettableFuture<Void> getPhase1Trigger() {
            return this.triggerPhase1;
        }

        public SettableFuture<Void> getTenantTrigger() {
            return this.triggerTenant;
        }
    }
}

