/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.spi.fields;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.confluence.plugins.cql.spi.fields.UserSubFieldFactory;
import com.atlassian.confluence.plugins.cql.spi.sort.BaseUserSort;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchQueryWrapper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchSortWrapper;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.querylang.fields.BaseFieldHandler;
import com.atlassian.querylang.fields.EqualityFieldHandler;
import com.atlassian.querylang.fields.FieldHandler;
import com.atlassian.querylang.fields.expressiondata.EqualityExpressionData;
import com.atlassian.querylang.fields.expressiondata.SetExpressionData;
import com.atlassian.querylang.query.FieldOrder;
import com.atlassian.querylang.query.OrderDirection;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;

@ExperimentalSpi
public abstract class AbstractUserFieldHandler
extends BaseFieldHandler
implements EqualityFieldHandler<String, V2SearchQueryWrapper> {
    private final UserSubFieldFactory subFieldFactory;

    public AbstractUserFieldHandler(String fieldName, UserSubFieldFactory subFieldFactory) {
        super(fieldName, true);
        this.subFieldFactory = subFieldFactory;
    }

    public V2SearchQueryWrapper build(SetExpressionData expressionData, Iterable<String> values) {
        this.validateSupportedOp((Enum)((SetExpressionData.Operator)expressionData.getOperator()), Sets.newHashSet((Object[])new SetExpressionData.Operator[]{SetExpressionData.Operator.IN, SetExpressionData.Operator.NOT_IN}));
        SearchQuery query = this.createUserQuery(values);
        return V2FieldHandlerHelper.wrapV2Search(query, expressionData);
    }

    public V2SearchQueryWrapper build(EqualityExpressionData expressionData, String value) {
        this.validateSupportedOp((Enum)((EqualityExpressionData.Operator)expressionData.getOperator()), Sets.newHashSet((Object[])new EqualityExpressionData.Operator[]{EqualityExpressionData.Operator.EQUALS, EqualityExpressionData.Operator.NOT_EQUALS}));
        SearchQuery query = this.createUserQuery(value);
        return V2FieldHandlerHelper.wrapV2Search(query, expressionData);
    }

    protected abstract SearchQuery createUserQuery(String var1);

    public abstract SearchQuery createUserQuery(UserKey var1, String var2);

    protected SearchQuery createUserQuery(Iterable<String> values) {
        LinkedHashSet<SearchQuery> queries = new LinkedHashSet<SearchQuery>();
        for (String value : values) {
            queries.add(this.createUserQuery(value));
        }
        return V2FieldHandlerHelper.orIfNecessary(queries);
    }

    public FieldOrder buildOrder(OrderDirection direction) {
        return this.buildOrder(direction, BaseUserSort.UserSortType.FULLNAME);
    }

    public FieldOrder buildOrder(OrderDirection direction, BaseUserSort.UserSortType userSortType) {
        return new V2SearchSortWrapper((SearchSort)new BaseUserSort(userSortType, V2SearchSortWrapper.convertOrder(direction), this.getIndexFieldName()));
    }

    protected abstract String getIndexFieldName();

    public Iterable<FieldHandler> getSubfieldHandlers() {
        return this.subFieldFactory != null ? this.subFieldFactory.createUserSubfields(this) : Collections.emptyList();
    }

    public Map<String, FieldHandler> getSubfieldHandlersAsMap() {
        return Maps.uniqueIndex(this.getSubfieldHandlers(), FieldHandler::fieldName);
    }
}

