/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.spi.fields;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchSortWrapper;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.querylang.exceptions.GenericQueryException;
import com.atlassian.querylang.fields.BaseFieldHandler;
import com.atlassian.querylang.fields.FieldMetaData;
import com.atlassian.querylang.fields.NumericFieldHandler;
import com.atlassian.querylang.fields.expressiondata.RangeExpressionData;
import com.atlassian.querylang.query.FieldOrder;
import com.atlassian.querylang.query.OrderDirection;
import com.atlassian.querylang.query.SearchQuery;
import com.google.common.collect.Sets;

@ExperimentalSpi
public abstract class AbstractNumericFieldHandler<T extends Number>
extends BaseFieldHandler
implements NumericFieldHandler<SearchQuery> {
    protected AbstractNumericFieldHandler(String fieldName) {
        super(fieldName, true);
    }

    protected AbstractNumericFieldHandler(String fieldName, FieldMetaData fieldMetaData) {
        super(fieldName, fieldMetaData, true);
    }

    public SearchQuery build(RangeExpressionData rangeExpressionData, String value) {
        this.validateSupportedOp((Enum)((RangeExpressionData.Operator)rangeExpressionData.getOperator()), Sets.newHashSet((Object[])new RangeExpressionData.Operator[]{RangeExpressionData.Operator.EQUALS, RangeExpressionData.Operator.NOT_EQUALS, RangeExpressionData.Operator.LESS, RangeExpressionData.Operator.LESS_OR_EQUALS, RangeExpressionData.Operator.GREATER, RangeExpressionData.Operator.GREATER_OR_EQUALS}));
        return this.getQuery(rangeExpressionData, this.getValue(value));
    }

    private T getValue(String str) {
        try {
            return this.parseNumber(str);
        }
        catch (NumberFormatException nfe) {
            throw new GenericQueryException(String.format("field %s requires a value between %s and %s instead got %s", this.fieldName, String.valueOf(this.min()), String.valueOf(this.max()), str));
        }
    }

    public FieldOrder buildOrder(OrderDirection direction) {
        SearchSort.Order order = direction == OrderDirection.ASC ? SearchSort.Order.ASCENDING : SearchSort.Order.DESCENDING;
        return new V2SearchSortWrapper(this.getSearchSort(order));
    }

    protected abstract T parseNumber(String var1);

    protected abstract SearchSort getSearchSort(SearchSort.Order var1);

    protected abstract T max();

    protected abstract T min();

    protected abstract com.atlassian.confluence.search.v2.SearchQuery createQuery(T var1, T var2, boolean var3, boolean var4);

    protected SearchQuery getQuery(RangeExpressionData expressionData, T value) {
        switch ((RangeExpressionData.Operator)expressionData.getOperator()) {
            case GREATER: {
                return V2FieldHandlerHelper.wrapV2Search(this.createQuery(value, this.max(), false, false), expressionData);
            }
            case GREATER_OR_EQUALS: {
                return V2FieldHandlerHelper.wrapV2Search(this.createQuery(value, this.max(), true, false), expressionData);
            }
            case LESS: {
                return V2FieldHandlerHelper.wrapV2Search(this.createQuery(this.min(), value, false, false), expressionData);
            }
            case LESS_OR_EQUALS: {
                return V2FieldHandlerHelper.wrapV2Search(this.createQuery(this.min(), value, false, true), expressionData);
            }
            case EQUALS: 
            case NOT_EQUALS: {
                return V2FieldHandlerHelper.wrapV2Search(this.createQuery(value, value, true, true), expressionData);
            }
        }
        throw new UnsupportedOperationException("Unrecognised case " + expressionData.getOperator());
    }
}

