/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.spi.fields;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchQueryWrapper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchSortWrapper;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import com.atlassian.querylang.fields.BaseFieldHandler;
import com.atlassian.querylang.fields.DateTimeFieldHandler;
import com.atlassian.querylang.fields.DateTimePrecision;
import com.atlassian.querylang.fields.FieldMetaData;
import com.atlassian.querylang.fields.expressiondata.RangeExpressionData;
import com.atlassian.querylang.query.FieldOrder;
import com.atlassian.querylang.query.OrderDirection;
import com.google.common.collect.Sets;

@ExperimentalSpi
public abstract class AbstractDateRangeFieldHandler
extends BaseFieldHandler
implements DateTimeFieldHandler<V2SearchQueryWrapper> {
    protected AbstractDateRangeFieldHandler(String fieldName) {
        super(fieldName, true);
    }

    protected AbstractDateRangeFieldHandler(String fieldName, FieldMetaData fieldMetaData) {
        super(fieldName, fieldMetaData, true);
    }

    protected abstract DateRangeQuery.Builder newDateRangeBuilder();

    private DateRangeQuery.Builder getDateRangeBuilder() {
        return this.newDateRangeBuilder().includeFrom(true).includeTo(true);
    }

    protected abstract SearchSort getSearchSort(SearchSort.Order var1);

    public V2SearchQueryWrapper build(RangeExpressionData rangeExpressionData, DateTimePrecision value) {
        this.validateSupportedOp((Enum)((RangeExpressionData.Operator)rangeExpressionData.getOperator()), Sets.newHashSet((Object[])new RangeExpressionData.Operator[]{RangeExpressionData.Operator.EQUALS, RangeExpressionData.Operator.NOT_EQUALS, RangeExpressionData.Operator.LESS, RangeExpressionData.Operator.LESS_OR_EQUALS, RangeExpressionData.Operator.GREATER, RangeExpressionData.Operator.GREATER_OR_EQUALS}));
        DateRangeQuery query = this.getDateRangeQuery(rangeExpressionData, value);
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)query, rangeExpressionData);
    }

    public FieldOrder buildOrder(OrderDirection direction) {
        return new V2SearchSortWrapper(this.getSearchSort(V2SearchSortWrapper.convertOrder(direction)));
    }

    private DateRangeQuery getDateRangeQuery(RangeExpressionData expressionData, DateTimePrecision value) {
        switch ((RangeExpressionData.Operator)expressionData.getOperator()) {
            case GREATER: {
                return this.greaterThan(value);
            }
            case GREATER_OR_EQUALS: {
                return this.greaterThanEquals(value);
            }
            case LESS: {
                return this.lessThan(value);
            }
            case LESS_OR_EQUALS: {
                return this.lessThanEquals(value);
            }
            case EQUALS: 
            case NOT_EQUALS: {
                return this.equalsOp(value);
            }
        }
        throw new UnsupportedOperationException("Unrecognised case " + expressionData.getOperator());
    }

    private DateRangeQuery greaterThan(DateTimePrecision value) {
        return this.getDateRangeBuilder().includeFrom(true).fromDate(value.calcEndDateTimeExclusive()).build();
    }

    private DateRangeQuery greaterThanEquals(DateTimePrecision value) {
        return this.getDateRangeBuilder().includeFrom(true).fromDate(value.calcStartDateTimeInclusive()).build();
    }

    private DateRangeQuery lessThan(DateTimePrecision value) {
        return this.getDateRangeBuilder().includeTo(false).toDate(value.calcStartDateTimeInclusive()).build();
    }

    private DateRangeQuery lessThanEquals(DateTimePrecision value) {
        return this.getDateRangeBuilder().includeTo(false).toDate(value.calcEndDateTimeExclusive()).build();
    }

    private DateRangeQuery equalsOp(DateTimePrecision value) {
        DateRangeQuery.Builder builder = this.getDateRangeBuilder().includeFrom(true).includeTo(false).fromDate(value.calcStartDateTimeInclusive()).toDate(value.calcEndDateTimeExclusive());
        return builder.build();
    }
}

