/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.spi.v2searchhelpers;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.plugins.cql.spi.v2search.query.NotQuery;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchQueryWrapper;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.querylang.fields.expressiondata.ExpressionData;
import com.atlassian.querylang.fields.expressiondata.NegatableOperator;
import com.atlassian.querylang.literals.StringLiteralHelper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;

public class V2FieldHandlerHelper {
    public static final Function<String, ContentId> stringToContentId = new Function<String, ContentId>(){

        public ContentId apply(String input) {
            return ContentId.valueOf((String)StringLiteralHelper.stripQuotes((String)input));
        }
    };

    private static <T extends Enum> SearchQuery negateIfNecessary(SearchQuery query, ExpressionData<T> opCtx) {
        if (((NegatableOperator)opCtx.getOperator()).negate()) {
            return V2FieldHandlerHelper.negate(query);
        }
        return query;
    }

    public static SearchQuery negate(SearchQuery query) {
        return new NotQuery(query);
    }

    public static SearchQuery orIfNecessary(Set<? extends SearchQuery> queries) {
        if (queries.size() > 1) {
            return BooleanQuery.composeOrQuery(queries);
        }
        return queries.iterator().next();
    }

    public static <T> SearchQuery joinSingleValueQueries(Iterable<T> values, Function<T, ? extends SearchQuery> searchQueryProducer) {
        ImmutableSet valueSet = ImmutableSet.copyOf(values);
        Iterable queries = Iterables.transform((Iterable)valueSet, searchQueryProducer);
        return V2FieldHandlerHelper.orIfNecessary((Set<? extends SearchQuery>)ImmutableSet.copyOf((Iterable)queries));
    }

    public static <T extends Enum, E extends ExpressionData<T>> V2SearchQueryWrapper wrapV2Search(SearchQuery query, E expression) {
        return new V2SearchQueryWrapper(V2FieldHandlerHelper.negateIfNecessary(query, expression));
    }
}

