/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.impl;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.content.ContentTypeManager;
import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.content.CustomContentManager;
import com.atlassian.confluence.content.apisupport.ContentTypeApiSupport;
import com.atlassian.confluence.content.custom.CustomContentType;
import com.atlassian.confluence.content.ui.ContentUiSupport;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.event.events.plugin.PluginEvent;
import com.atlassian.confluence.plugins.cql.rest.DisplayableType;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchTypeManager
implements InitializingBean,
DisposableBean {
    public static final String SPACE_TYPE = "space";
    public static final String USER_TYPE = "user";
    private static final String SPACE_I18N_KEY = "space.name";
    private static final String USER_I18N_KEY = "user.name";
    private static final String TEAM_CALENDAR_MODULE_KEY = "com.atlassian.confluence.extra.team-calendars:calendar-content-type";
    private static final String QUESTIONS_MODULE_KEY = "com.atlassian.confluence.plugins.confluence-questions:question";
    private static final String ANSWERS_MODULE_KEY = "com.atlassian.confluence.plugins.confluence-questions:answer";
    private static final Logger log = LoggerFactory.getLogger(SearchTypeManager.class);
    private static final Function<DisplayableType, String> TYPE_KEY_FUNC = v -> v.getType().toLowerCase();
    private final ContentTypeManager contentTypeManager;
    private final CustomContentManager customContentManager;
    private final I18nResolver i18nResolver;
    private final ContentUiSupport contentUiSupport;
    private final PluginEventManager pluginEventManager;
    private Set<ContentType> malfunctioningTypes = Sets.newHashSet();
    private static final ImmutableList<ContentType> SUPPORTED_BUILT_IN_CONTENT_TYPES = ImmutableList.of((Object)ContentType.PAGE, (Object)ContentType.BLOG_POST, (Object)ContentType.COMMENT, (Object)ContentType.ATTACHMENT);

    @Autowired
    public SearchTypeManager(@ComponentImport ContentTypeManager contentTypeManager, @ComponentImport CustomContentManager customContentManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport ContentUiSupport contentUiSupport, @ComponentImport PluginEventManager pluginEventManager) {
        this.contentTypeManager = contentTypeManager;
        this.customContentManager = customContentManager;
        this.i18nResolver = i18nResolver;
        this.contentUiSupport = contentUiSupport;
        this.pluginEventManager = pluginEventManager;
    }

    public void destroy() {
        this.pluginEventManager.unregister((Object)this);
    }

    public void afterPropertiesSet() {
        this.pluginEventManager.register((Object)this);
    }

    public Map<String, DisplayableType> getContentTypes() {
        return Maps.uniqueIndex((Iterable)Iterables.concat((Iterable)Iterables.transform(SUPPORTED_BUILT_IN_CONTENT_TYPES, this::transformBuiltIn), this.getCustomContentTypes()), TYPE_KEY_FUNC);
    }

    private Map<String, DisplayableType> getBuiltinContentTypesByLabel() {
        return Maps.uniqueIndex((Iterable)Iterables.transform(SUPPORTED_BUILT_IN_CONTENT_TYPES, this::transformBuiltIn), v -> v.getLabel().toLowerCase());
    }

    private Iterable<DisplayableType> getCustomContentTypes() {
        Map<String, DisplayableType> builtInLabels = this.getBuiltinContentTypesByLabel();
        ArrayList types = Lists.newArrayList();
        for (CustomContentType type : this.contentTypeManager.getEnabledCustomContentTypes()) {
            try {
                if (this.malfunctioningTypes.contains(type.getApiSupport().getHandledType()) || !type.getPermissionDelegate().canView((User)AuthenticatedUserThreadLocal.get())) continue;
                ContentTypeApiSupport support = type.getApiSupport();
                CustomContentEntityObject ceo = this.customContentManager.newPluginContentEntityObject(support.getHandledType().serialise());
                if (!type.getPermissionDelegate().canView((User)AuthenticatedUserThreadLocal.get())) continue;
                String i18nKey = type.getContentUiSupport().getContentTypeI18NKey((ConfluenceEntityObject)ceo);
                String label = this.i18nResolver.getText(i18nKey);
                if (StringUtils.isBlank((CharSequence)label) && TEAM_CALENDAR_MODULE_KEY.equals(ceo.getPluginModuleKey())) {
                    label = "Calendars";
                } else if (i18nKey.equals("question") && QUESTIONS_MODULE_KEY.equals(ceo.getPluginModuleKey())) {
                    i18nKey = "question.searchtype.name";
                    label = this.i18nResolver.getText(i18nKey);
                } else if (i18nKey.equals("answer") && ANSWERS_MODULE_KEY.equals(ceo.getPluginModuleKey())) {
                    i18nKey = "answer.searchtype.name";
                    label = this.i18nResolver.getText(i18nKey);
                }
                if (label == null) continue;
                if (!builtInLabels.containsKey(label.toLowerCase())) {
                    types.add(DisplayableType.builder().type(support.getHandledType()).i18nKey(i18nKey).label(label).build());
                    continue;
                }
                ContentType contentType = type.getApiSupport().getHandledType();
                log.error("A plugin installed content type has duplicated a built-in content type label ({}), removing custom content type from CQL handled types : {}", (Object)label, (Object)contentType);
                this.malfunctioningTypes.add(contentType);
            }
            catch (Exception ex) {
                ContentType contentType = type.getApiSupport().getHandledType();
                log.error("A plugin installed content type caused an error for the CQL plugin, removing custom content type from CQL handled types : " + contentType, (Throwable)ex);
                this.malfunctioningTypes.add(contentType);
            }
        }
        return types;
    }

    public Map<String, DisplayableType> getTypes() {
        DisplayableType spaceType = DisplayableType.builder().type(SPACE_TYPE).label(this.i18nResolver.getText(SPACE_I18N_KEY)).i18nKey(SPACE_I18N_KEY).build();
        DisplayableType userType = DisplayableType.builder().type(USER_TYPE).label(this.i18nResolver.getText(USER_I18N_KEY)).i18nKey(USER_I18N_KEY).build();
        return ImmutableMap.builder().put((Object)((String)TYPE_KEY_FUNC.apply((Object)spaceType)), (Object)spaceType).put((Object)((String)TYPE_KEY_FUNC.apply((Object)userType)), (Object)userType).putAll(this.getContentTypes()).build();
    }

    public boolean hasType(String type) {
        return this.getTypes().containsKey(type.toLowerCase());
    }

    @PluginEventListener
    public void clearMalfunctioningTypesDueToChangeInPluginState(PluginEvent e) {
        this.malfunctioningTypes.clear();
    }

    public String getIconCssClass(SearchResult result) {
        String iconCssClass = this.contentUiSupport.getIconCssClass(result);
        boolean noIconClass = Strings.isNullOrEmpty((String)iconCssClass);
        if (noIconClass || iconCssClass.contains("icon-question")) {
            String contentPluginKey = result.getField("contentPluginKey");
            String pluginKeyIcon = "icon-" + contentPluginKey.replaceAll("[\\.:]", "-");
            iconCssClass = noIconClass ? pluginKeyIcon : iconCssClass + " " + pluginKeyIcon;
        } else {
            iconCssClass = iconCssClass.replace("aui-icon aui-icon-small ", "");
        }
        return iconCssClass;
    }

    private DisplayableType transformBuiltIn(ContentType input) {
        String i18nKey = "content-type.label." + input.serialise();
        return DisplayableType.builder().type(input).i18nKey(i18nKey).label(this.i18nResolver.getText(i18nKey)).build();
    }
}

