/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.fields;

import com.atlassian.confluence.plugins.cql.impl.SearchTypeManager;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchQueryWrapper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchSortWrapper;
import com.atlassian.confluence.plugins.cql.v2search.sort.ContentTypeSort;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.CustomContentTypeQuery;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.querylang.exceptions.MissingValueQueryException;
import com.atlassian.querylang.fields.BaseFieldHandler;
import com.atlassian.querylang.fields.EqualityFieldHandler;
import com.atlassian.querylang.fields.expressiondata.EqualityExpressionData;
import com.atlassian.querylang.fields.expressiondata.ExpressionData;
import com.atlassian.querylang.fields.expressiondata.SetExpressionData;
import com.atlassian.querylang.query.FieldOrder;
import com.atlassian.querylang.query.OrderDirection;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTypeFieldHandler
extends BaseFieldHandler
implements EqualityFieldHandler<String, V2SearchQueryWrapper> {
    private static final Logger log = LoggerFactory.getLogger(ContentTypeFieldHandler.class);
    private static final String FIELD_NAME = "type";
    private static final ImmutableSet<SetExpressionData.Operator> SET_OPERATORS = ImmutableSet.of((Object)SetExpressionData.Operator.IN, (Object)SetExpressionData.Operator.NOT_IN);
    private static final ImmutableSet<EqualityExpressionData.Operator> EQUALS_OPERATORS = ImmutableSet.of((Object)EqualityExpressionData.Operator.EQUALS, (Object)EqualityExpressionData.Operator.NOT_EQUALS);
    private final SearchTypeManager searchTypeManager;
    private Function<String, Set<ContentTypeEnum>> builtInTypeFromValues = value -> {
        String lowerCase = value.toLowerCase();
        this.checkTypeExists(lowerCase);
        ContentTypeEnum typeEnum = ContentTypeEnum.getByRepresentation((String)lowerCase);
        if (typeEnum != null) {
            if (typeEnum.equals((Object)ContentTypeEnum.SPACE)) {
                return ImmutableSet.of((Object)ContentTypeEnum.SPACE_DESCRIPTION, (Object)ContentTypeEnum.PERSONAL_SPACE_DESCRIPTION);
            }
            return ImmutableSet.of((Object)typeEnum);
        }
        if (value.equals("user")) {
            return ImmutableSet.of((Object)ContentTypeEnum.PERSONAL_INFORMATION);
        }
        return Collections.emptySet();
    };
    private Function<String, Set<String>> customTypesFromValues = value -> {
        String lowerCase = value.toLowerCase();
        this.checkTypeExists(lowerCase);
        Set typeEnum = (Set)this.builtInTypeFromValues.apply((Object)lowerCase);
        if (typeEnum.isEmpty()) {
            return ImmutableSet.of((Object)value);
        }
        return Collections.emptySet();
    };

    public ContentTypeFieldHandler(SearchTypeManager searchTypeManager) {
        super(FIELD_NAME, true);
        this.searchTypeManager = searchTypeManager;
    }

    public V2SearchQueryWrapper build(EqualityExpressionData expressionData, String value) {
        this.validateSupportedOp((Enum)((EqualityExpressionData.Operator)expressionData.getOperator()), (Set)EQUALS_OPERATORS);
        SearchQuery query = this.getV2SearchQueryFromValues((Iterable<String>)Option.option((Object)value));
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)query, (ExpressionData)expressionData);
    }

    public V2SearchQueryWrapper build(SetExpressionData expressionData, Iterable<String> values) {
        this.validateSupportedOp((Enum)((SetExpressionData.Operator)expressionData.getOperator()), (Set)SET_OPERATORS);
        SearchQuery query = this.getV2SearchQueryFromValues(values);
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)query, (ExpressionData)expressionData);
    }

    private SearchQuery getV2SearchQueryFromValues(Iterable<String> values) {
        Iterable customTypes;
        Iterable builtInTypes = Iterables.memoize((Iterable)com.google.common.collect.Iterables.concat((Iterable)com.google.common.collect.Iterables.transform(values, this.builtInTypeFromValues)));
        Object query = null;
        if (!com.google.common.collect.Iterables.isEmpty((Iterable)builtInTypes)) {
            query = new ContentTypeQuery((Collection)Lists.newArrayList((Iterable)builtInTypes));
        }
        if (!com.google.common.collect.Iterables.isEmpty((Iterable)(customTypes = Iterables.memoize((Iterable)com.google.common.collect.Iterables.concat((Iterable)com.google.common.collect.Iterables.transform(values, this.customTypesFromValues)))))) {
            CustomContentTypeQuery customTypeQuery = new CustomContentTypeQuery((Collection)Lists.newArrayList((Iterable)customTypes));
            query = query == null ? customTypeQuery : BooleanQuery.orQuery((SearchQuery[])new SearchQuery[]{query, customTypeQuery});
        }
        return query;
    }

    private void checkTypeExists(String lowerCaseType) {
        if (!this.searchTypeManager.hasType(lowerCaseType)) {
            log.debug("Unsupported type : " + lowerCaseType);
            throw new MissingValueQueryException(String.format("Unsupported value for type, got : %s, expected one of : %s", lowerCaseType, this.searchTypeManager.getTypes().keySet()));
        }
    }

    public FieldOrder buildOrder(OrderDirection direction) {
        return new V2SearchSortWrapper((SearchSort)ContentTypeSort.forDirection(direction));
    }
}

