AJS.toInit(function ($) {

    var url = "/rest/experimental/content/";

    function renderData(data){
        if (!data) {
            return;
        }

        var resultHtml;
        if (data.size > 0) {
            resultHtml = Confluence.Templates.CQL.resultList({
                baseUrl: AJS.Meta.get('base-url'),
                resultList: data.results
            });
        }
        else {
            resultHtml = AJS.messages.info({body: "<p>Query was understood but no results found</p>"});
        }
        $("#cqlresult").html(resultHtml);
    }

    function fetchContent(cql){
        $("#cqlresult").html("Loading...");
        var getUrl = Confluence.getContextPath() + url + "?cql=" + encodeURIComponent(cql) + "&expand=space";
        $.ajax({
            type: "GET",
            url: getUrl,
            dataType: "json"

        }).success(function(data){
            renderData(data);

        }).fail(function(data){
            var error = $.parseJSON(data.responseText);
            error = error.message ? error.message : data.responseText;

            $("#cqlresult").html(Confluence.Templates.CQL.errorMessage({message: error}));
        });
    }

    $("#cqlsearchform").submit(function(e){
        e.preventDefault();
        fetchContent($("#cql")[0].value);
    });
});