/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.v2search.sort;

import com.atlassian.confluence.plugins.cql.v2search.sort.MultiSearchSort;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchMapper;
import com.atlassian.confluence.search.v2.lucene.LuceneSortMapper;
import com.atlassian.confluence.search.v2.sort.RelevanceSort;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class MultiSearchSortMapper
implements LuceneSortMapper {
    private final LuceneSearchMapper searchMapper;

    public MultiSearchSortMapper(@ComponentImport LuceneSearchMapper searchMapper) {
        this.searchMapper = searchMapper;
    }

    public Sort convertToLuceneSort(SearchSort searchSort) {
        MultiSearchSort multiSearchSort = (MultiSearchSort)searchSort;
        ArrayList sortFields = Lists.newArrayList();
        for (SearchSort sort : multiSearchSort.getSearchSorts()) {
            if (sort instanceof RelevanceSort) {
                sortFields.addAll(Arrays.asList(Sort.RELEVANCE.getSort()));
                continue;
            }
            sortFields.addAll(Arrays.asList(this.searchMapper.convertToLuceneSort(sort).getSort()));
        }
        return new Sort(sortFields.toArray(new SortField[sortFields.size()]));
    }
}

