/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.v2search.query;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.content.id.AttachmentContentId;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.plugins.cql.v2search.query.ContentIdQuery;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ContentIdFieldMapper
implements LuceneQueryMapper<ContentIdQuery> {
    public Query convertToLuceneQuery(ContentIdQuery contentIdQuery) {
        BooleanQuery boolQuery = new BooleanQuery();
        for (ContentId contentId : contentIdQuery.getContentIds()) {
            if (contentId instanceof AttachmentContentId) {
                String fieldValue = ContentIdQuery.buildHandleFieldValue(contentId, Attachment.class);
                boolQuery.add((Query)new TermQuery(new Term("handle", fieldValue)), BooleanClause.Occur.SHOULD);
                continue;
            }
            for (Class<? extends Searchable> searchableClass : ContentIdQuery.SUPPORTED_CLASSES) {
                String fieldValue = ContentIdQuery.buildHandleFieldValue(contentId, searchableClass);
                boolQuery.add((Query)new TermQuery(new Term("handle", fieldValue)), BooleanClause.Occur.SHOULD);
            }
        }
        return boolQuery;
    }
}

