/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.v2search.query;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.plugins.cql.v2search.query.ContentContainerQuery;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ContentContainerQueryMapper
implements LuceneQueryMapper<ContentContainerQuery> {
    public Query convertToLuceneQuery(ContentContainerQuery contentContainerQuery) {
        BooleanQuery query = new BooleanQuery();
        for (ContentId contentId : contentContainerQuery.getParameters()) {
            query.add((Query)new TermQuery(new Term("containingPageId", contentId.serialise())), BooleanClause.Occur.SHOULD);
            BooleanQuery attachmentQuery = new BooleanQuery();
            attachmentQuery.add((Query)new TermQuery(new Term("ancestorIds", contentId.serialise())), BooleanClause.Occur.MUST);
            attachmentQuery.add((Query)new TermQuery(new Term("type", ContentTypeEnum.ATTACHMENT.getRepresentation())), BooleanClause.Occur.MUST);
            query.add((Query)attachmentQuery, BooleanClause.Occur.SHOULD);
        }
        return query;
    }
}

