/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.v2search.query;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.plugins.cql.v2search.query.AncestorIdQuery;
import com.atlassian.confluence.plugins.cql.v2search.query.ContentIdFieldMapper;
import com.atlassian.confluence.plugins.cql.v2search.query.ContentIdQuery;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class AncestorIdQueryMapper
implements LuceneQueryMapper<AncestorIdQuery> {
    private final ContentIdFieldMapper contentIdMapper = new ContentIdFieldMapper();

    public Query convertToLuceneQuery(AncestorIdQuery ancestorIdQuery) {
        BooleanQuery setOfAncestors = new BooleanQuery();
        for (ContentId id : ancestorIdQuery.getParameters()) {
            BooleanQuery childrenOfOnly = new BooleanQuery();
            childrenOfOnly.add((Query)new TermQuery(new Term("ancestorIds", id.serialise())), BooleanClause.Occur.MUST);
            childrenOfOnly.add(this.contentIdMapper.convertToLuceneQuery(new ContentIdQuery(id)), BooleanClause.Occur.MUST_NOT);
            setOfAncestors.add((Query)childrenOfOnly, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery contentTypeAndSetOfAncestors = new BooleanQuery();
        contentTypeAndSetOfAncestors.add((Query)setOfAncestors, BooleanClause.Occur.MUST);
        contentTypeAndSetOfAncestors.add((Query)new TermQuery(new Term("type", ContentTypeEnum.PAGE.getRepresentation())), BooleanClause.Occur.MUST);
        return contentTypeAndSetOfAncestors;
    }
}

