/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.fields;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.ChildContentService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchQueryWrapper;
import com.atlassian.confluence.plugins.cql.v2search.query.ContentIdQuery;
import com.atlassian.confluence.plugins.cql.v2search.query.NoneQuery;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.querylang.fields.BaseFieldHandler;
import com.atlassian.querylang.fields.EqualityFieldHandler;
import com.atlassian.querylang.fields.expressiondata.EqualityExpressionData;
import com.atlassian.querylang.fields.expressiondata.ExpressionData;
import com.atlassian.querylang.fields.expressiondata.SetExpressionData;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;

public class ParentFieldHandler
extends BaseFieldHandler
implements EqualityFieldHandler<String, V2SearchQueryWrapper> {
    static final int MAX_TO_FETCH = 1001;
    private ContentService contentService;
    private ChildContentService childContentService;

    public ParentFieldHandler(@ComponentImport ContentService contentService, @ComponentImport ChildContentService childContentService) {
        super("parent");
        this.contentService = contentService;
        this.childContentService = childContentService;
    }

    public V2SearchQueryWrapper build(SetExpressionData expressionData, Iterable<String> values) {
        this.validateSupportedOp(expressionData.getOperator(), Collections.emptySet());
        return null;
    }

    public V2SearchQueryWrapper build(EqualityExpressionData expressionData, String value) {
        Iterable<Content> children;
        this.validateSupportedOp(expressionData.getOperator(), Sets.newHashSet((Object[])new EqualityExpressionData.Operator[]{EqualityExpressionData.Operator.EQUALS, EqualityExpressionData.Operator.NOT_EQUALS}));
        ContentId contentId = (ContentId)V2FieldHandlerHelper.stringToContentId.apply((Object)value);
        Content parent = (Content)this.contentService.find(new Expansion[0]).withId(contentId).fetchOneOrNull();
        if (parent == null) {
            return V2FieldHandlerHelper.wrapV2Search((SearchQuery)new NoneQuery(), (ExpressionData)expressionData);
        }
        if (parent.getType().equals((Object)ContentType.PAGE)) {
            children = this.fetchChildren(this.childContentService.findContent(contentId, new Expansion[0]), ContentType.PAGE);
        } else if (parent.getType().equals((Object)ContentType.COMMENT)) {
            children = this.fetchChildren(this.childContentService.findContent(contentId, new Expansion[0]), ContentType.COMMENT);
        } else {
            return V2FieldHandlerHelper.wrapV2Search((SearchQuery)new NoneQuery(), (ExpressionData)expressionData);
        }
        ContentIdQuery query = new ContentIdQuery(Iterables.transform(children, (Function)new Function<Content, ContentId>(){

            public ContentId apply(Content input) {
                return input.getId();
            }
        }));
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)query, (ExpressionData)expressionData);
    }

    private Iterable<Content> fetchChildren(ChildContentService.ChildContentFinder finder, ContentType type) {
        PageResponse response;
        Iterable<Object> results = Collections.emptyList();
        SimplePageRequest pageRequest = new SimplePageRequest(0, 1001);
        int count = 0;
        do {
            response = finder.fetchMany(type, (PageRequest)pageRequest);
            results = Iterables.concat(results, (Iterable)response);
            int offset = pageRequest.getStart() + pageRequest.getLimit();
            pageRequest = new SimplePageRequest(offset, 1001 - offset);
        } while (response.hasMore() && (count += response.size()) < 1001);
        return response;
    }
}

