/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.lib.functions;

import com.atlassian.querylang.functions.MultiValueQueryFunction;
import com.atlassian.querylang.functions.QueryFunction;
import com.atlassian.querylang.functions.SingleValueQueryFunction;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionRegistry {
    private static final Logger log = LoggerFactory.getLogger(FunctionRegistry.class);
    private Multimap<String, QueryFunction> singleValueFunctions = HashMultimap.create();
    private Multimap<String, QueryFunction> multiValueFunctions = HashMultimap.create();

    public void register(QueryFunction function) {
        if (this.getRegisteredFunction(function.name(), function.paramCount()) != null) {
            log.warn("A CQL function '" + function.getClass().getName() + "' expecting " + function.paramCount() + " parameter(s) has already been registered");
            return;
        }
        if (function instanceof SingleValueQueryFunction) {
            this.singleValueFunctions.put((Object)function.name(), (Object)function);
        } else if (function instanceof MultiValueQueryFunction) {
            this.multiValueFunctions.put((Object)function.name(), (Object)function);
        } else {
            throw new IllegalArgumentException("Unknown QueryFunction type");
        }
    }

    public boolean unregister(QueryFunction function) {
        if (function instanceof SingleValueQueryFunction) {
            return this.singleValueFunctions.remove((Object)function.name(), (Object)function);
        }
        if (function instanceof MultiValueQueryFunction) {
            return this.multiValueFunctions.remove((Object)function.name(), (Object)function);
        }
        throw new IllegalArgumentException("Unknown QueryFunction type");
    }

    public boolean isRegisteredSingleValueFunction(String name) {
        return this.singleValueFunctions.containsKey((Object)name);
    }

    public boolean isRegisteredMultiValueFunction(String name) {
        return this.multiValueFunctions.containsKey((Object)name);
    }

    public Collection<QueryFunction> getRegisteredFunction(String name) {
        if (this.isRegisteredSingleValueFunction(name)) {
            return this.singleValueFunctions.get((Object)name);
        }
        if (this.isRegisteredMultiValueFunction(name)) {
            return this.multiValueFunctions.get((Object)name);
        }
        return Collections.emptyList();
    }

    public SingleValueQueryFunction getRegisteredSingleValueFunction(String name, int paramCount) {
        QueryFunction registeredFunction = this.getRegisteredFunction(name, paramCount);
        if (registeredFunction == null) {
            this.throwFunctionNotFoundException(name, paramCount);
        } else if (registeredFunction instanceof SingleValueQueryFunction) {
            return (SingleValueQueryFunction)registeredFunction;
        }
        throw new IllegalArgumentException("The function '" + name + "' is not registered as a SingleValueFunction");
    }

    public MultiValueQueryFunction getRegisteredMultiValueFunction(String name, int paramCount) {
        QueryFunction registeredFunction = this.getRegisteredFunction(name, paramCount);
        if (registeredFunction == null) {
            this.throwFunctionNotFoundException(name, paramCount);
        }
        if (registeredFunction instanceof MultiValueQueryFunction) {
            return (MultiValueQueryFunction)registeredFunction;
        }
        throw new IllegalArgumentException("The function '" + name + "' is not registered as a MultiValueFunction");
    }

    public boolean hasSingleValueFunctionTakingParams(String functionName, int paramCount) {
        return this.hasFunctionOfTypeTakingParams(functionName, paramCount, SingleValueQueryFunction.class);
    }

    public boolean hasMultiValueFunctionTakingParams(String functionName, int paramCount) {
        return this.hasFunctionOfTypeTakingParams(functionName, paramCount, MultiValueQueryFunction.class);
    }

    private boolean hasFunctionOfTypeTakingParams(String functionName, int paramCount, Class type) {
        QueryFunction registeredFunction = this.getRegisteredFunction(functionName, paramCount);
        return type.isInstance(registeredFunction);
    }

    private void throwFunctionNotFoundException(String name, int paramCount) {
        throw new IllegalArgumentException("No function '" + name + "' containing " + paramCount + " argument(s) found");
    }

    private QueryFunction getRegisteredFunction(String name, int paramCount) {
        Iterator iterator = Iterables.filter(this.getRegisteredFunction(name), this.getParamCountPredicate(paramCount)::test).iterator();
        if (iterator.hasNext()) {
            QueryFunction matchingFunction = (QueryFunction)iterator.next();
            return matchingFunction;
        }
        return null;
    }

    private Predicate<QueryFunction> getParamCountPredicate(int paramCount) {
        return input -> input.paramCount() == paramCount;
    }
}

