/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.lib.plugins;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.querylang.fields.FieldHandler;
import com.atlassian.querylang.fields.FieldMetaData;
import com.atlassian.querylang.fields.UISupport;
import com.atlassian.querylang.fields.ValueTypeFactory;
import com.atlassian.querylang.lib.plugins.BaseAQLModuleDescriptor;
import com.atlassian.querylang.lib.plugins.UISupportFactory;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.util.Set;
import javax.annotation.Nonnull;
import org.dom4j.Element;
import org.reflections.ReflectionUtils;

@Scanned
public class AQLFieldModuleDescriptor
extends BaseAQLModuleDescriptor<FieldHandler> {
    private final ValueTypeFactory valueTypeFactory;
    private Option<String> fieldName;
    private Option<UISupport> uiSupport;

    public AQLFieldModuleDescriptor(@ComponentImport ModuleFactory moduleFactory, ValueTypeFactory valueTypeFactory) {
        super(moduleFactory);
        this.valueTypeFactory = valueTypeFactory;
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.fieldName = Option.option((Object)element.attributeValue("fieldName"));
        this.uiSupport = Option.option((Object)UISupportFactory.extractUISupport(element.element("ui-support"), this.valueTypeFactory));
    }

    @Override
    public void enabled() {
        super.enabled();
        this.overrideFieldNameAndMetadata();
    }

    private void overrideFieldNameAndMetadata() {
        FieldHandler fieldHandler = (FieldHandler)this.getModule();
        try {
            if (this.fieldName.isDefined() && !((String)this.fieldName.get()).equals(fieldHandler.fieldName())) {
                Field field = this.getSingleField("fieldName", fieldHandler.getClass());
                field.setAccessible(true);
                field.set(fieldHandler, this.fieldName.get());
            }
            if (this.uiSupport.isDefined()) {
                UISupport uiSupport = (UISupport)this.uiSupport.get();
                if (Strings.isNullOrEmpty((String)uiSupport.getI18nKey())) {
                    String i18nKey = "cql.field." + fieldHandler.fieldName();
                    uiSupport = uiSupport.copy().i18nKey(i18nKey).build();
                }
                FieldMetaData fieldMetaData = fieldHandler.getFieldMetaData().copy().uiSupport(uiSupport).build();
                Field field = this.getSingleField("fieldMetaData", fieldHandler.getClass());
                field.setAccessible(true);
                field.set(fieldHandler, fieldMetaData);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Field getSingleField(String fieldName, Class clazz) {
        Set fields = ReflectionUtils.getAllFields((Class)clazz, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)fieldName)});
        if (fields.size() != 1) {
            throw new IllegalStateException("Should have a single field named '" + fieldName + "' in the class hierarchy for " + clazz.getName() + " but instead found " + fields.size());
        }
        return (Field)Iterables.getFirst((Iterable)fields, null);
    }
}

