/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.lib.parserfactory;

import com.atlassian.querylang.antlrgen.AqlBaseVisitor;
import com.atlassian.querylang.antlrgen.AqlParser;
import com.atlassian.querylang.exceptions.GenericQueryException;
import com.atlassian.querylang.exceptions.InvalidFieldQueryException;
import com.atlassian.querylang.exceptions.InvalidFunctionQueryException;
import com.atlassian.querylang.exceptions.MissingOperatorQueryException;
import com.atlassian.querylang.exceptions.MissingParenQueryException;
import com.atlassian.querylang.exceptions.MissingValueQueryException;
import com.atlassian.querylang.exceptions.QueryException;
import com.atlassian.querylang.exceptions.ReservedKeyWordException;
import com.atlassian.querylang.exceptions.UnsupportedOperatorQueryException;
import com.atlassian.querylang.exceptions.UnterminatedStringQueryException;
import com.atlassian.querylang.lib.fields.FieldRegistry;
import com.atlassian.querylang.lib.functions.FunctionRegistry;
import org.antlr.v4.runtime.misc.NotNull;

public class ErrorParseTreeVisitor
extends AqlBaseVisitor {
    private FieldRegistry fieldRegistry;
    private FunctionRegistry functionRegistry;

    public ErrorParseTreeVisitor(FieldRegistry registry, FunctionRegistry functionRegistry) {
        this.fieldRegistry = registry;
        this.functionRegistry = functionRegistry;
    }

    @Override
    public Object visitAqlStatement(@NotNull AqlParser.AqlStatementContext ctx) {
        return super.visitAqlStatement(ctx);
    }

    @Override
    public Object visitErrorExpr(@NotNull AqlParser.ErrorExprContext ctx) {
        super.visitErrorExpr(ctx);
        throw new GenericQueryException("Encountered unmatched error expr when parsing query");
    }

    @Override
    public Object visitUnrecognisedClause(@NotNull AqlParser.UnrecognisedClauseContext ctx) {
        throw new GenericQueryException("Unrecognised clause at : " + ctx.getText());
    }

    @Override
    public Object visitUnrecognisedFieldError(@NotNull AqlParser.UnrecognisedFieldErrorContext ctx) {
        throw InvalidFieldQueryException.fieldDoesNotExist((String)ctx.unrecognisedField().getText(), this.fieldRegistry.getRegisteredFieldNames());
    }

    @Override
    public Object visitUnsupportedOperatorError(@NotNull AqlParser.UnsupportedOperatorErrorContext ctx) {
        String field = ctx.field().getText();
        String operator = ctx.getChild(1).getText();
        throw UnsupportedOperatorQueryException.operatorNotSupportedForField((String)operator, (String)field, this.fieldRegistry.getSupportedOperators(field));
    }

    @Override
    public Object visitMissingOperatorError(@NotNull AqlParser.MissingOperatorErrorContext ctx) {
        String field = ctx.field().getText();
        throw MissingOperatorQueryException.operatorMissingForField((String)field, this.fieldRegistry.getSupportedOperators(field));
    }

    @Override
    public Object visitMissingValueError(@NotNull AqlParser.MissingValueErrorContext ctx) {
        if (ctx.UNTERMINATED_STRING() != null) {
            throw UnterminatedStringQueryException.unterminatedStringException((String)ctx.UNTERMINATED_STRING().getText(), (String)ctx.field().getText());
        }
        if (ctx.dateTimeField() != null) {
            throw MissingValueQueryException.missingValueForDateTimeField((String)ctx.dateTimeField().getText(), (String)ctx.STRING().getText());
        }
        if (ctx.value() != null && ctx.value().reservedKeyWordError() != null) {
            throw this.visitReservedKeyWordError(ctx.value().reservedKeyWordError());
        }
        String actual = "";
        if (ctx.getChildCount() >= 3) {
            actual = ctx.getChild(2).getText();
        }
        throw MissingValueQueryException.missingValueForOperator((String)ctx.operator().getText(), (String)ctx.field().getText(), (String)actual);
    }

    @Override
    public Object visitUnmatchedRParen(@NotNull AqlParser.UnmatchedRParenContext ctx) {
        throw MissingParenQueryException.missingRightParenException((String)ctx.getChild(0).getText());
    }

    @Override
    public Object visitUnrecognisedFunction(@NotNull AqlParser.UnrecognisedFunctionContext ctx) {
        String functionName = ctx.STRING().getText();
        if (this.functionRegistry.isRegisteredSingleValueFunction(functionName)) {
            throw InvalidFunctionQueryException.invalidSingleValueFunctionUsage((String)functionName);
        }
        if (this.functionRegistry.isRegisteredMultiValueFunction(functionName)) {
            throw InvalidFunctionQueryException.invalidMultiValueFunctionUsage((String)functionName);
        }
        throw InvalidFunctionQueryException.invalidFunction((String)ctx.getText());
    }

    @Override
    public QueryException visitReservedKeyWordError(@NotNull AqlParser.ReservedKeyWordErrorContext ctx) {
        throw new ReservedKeyWordException(ctx.getText());
    }
}

