/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.literals;

import com.atlassian.querylang.exceptions.GenericQueryException;
import com.atlassian.querylang.fields.DateTimePrecision;
import com.atlassian.querylang.literals.StringLiteralHelper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadablePeriod;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class DateLiteralHelper {
    private static final DateTimeFormatter dateFormatter;
    private static final DateTimeFormatter dateTimeFormatter;
    private static final String DATE_SLASH_PATTERN = "yyyy/MM/dd";
    private static final String DATE_DASH_PATTERN = "yyyy-MM-dd";
    private static final String TIME_PATTERN = " HH:mm";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm";
    public static final List<String> SUPPORTED_DATE_FORMATS;

    public static boolean isValidDate(String value) {
        return DateLiteralHelper.isValidWithFormatter(value, dateFormatter);
    }

    public static boolean isValidDateTime(String value) {
        return DateLiteralHelper.isValidWithFormatter(value, dateTimeFormatter);
    }

    public static DateTimePrecision create(String value) {
        if (DateLiteralHelper.isValidDateTime(value)) {
            return DateLiteralHelper.createDateTime(value);
        }
        if (DateLiteralHelper.isValidDate(value)) {
            return DateLiteralHelper.createDate(value);
        }
        throw new IllegalArgumentException(String.format("Date value '%s' is invalid.  Valid formats include: %s", value, StringUtils.join(SUPPORTED_DATE_FORMATS, (String)",")));
    }

    public static DateTimePrecision createDate(String value) {
        return DateLiteralHelper.createWithFormatter(value, DateTimePrecision.Precision.DAY, dateFormatter);
    }

    public static DateTimePrecision createDateTime(String value) {
        return DateLiteralHelper.createWithFormatter(value, DateTimePrecision.Precision.MINUTE, dateTimeFormatter);
    }

    private static boolean isValidWithFormatter(String value, DateTimeFormatter formatter) {
        try {
            String noQuotes = StringLiteralHelper.stripQuotes(value);
            if (noQuotes.length() < 10 || !Character.isDigit(noQuotes.charAt(3))) {
                return false;
            }
            formatter.parseDateTime(noQuotes);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static DateTimePrecision createWithFormatter(String value, DateTimePrecision.Precision precision, DateTimeFormatter formatter) {
        String noQuotes = StringLiteralHelper.stripQuotes(value);
        return new DateTimePrecision(formatter.parseDateTime(noQuotes), precision);
    }

    @Deprecated
    public static List<String> getSupportedDateFormats() {
        return SUPPORTED_DATE_FORMATS;
    }

    @Deprecated
    public static String toDateTimeString(DateTime dateTime) {
        return dateTime.toString(DATE_TIME_PATTERN);
    }

    public static ReadablePeriod toDateTime(String relativeDate) {
        int intValue;
        String trimmedDate = StringLiteralHelper.stripQuotes(relativeDate);
        char suffix = trimmedDate.charAt(trimmedDate.length() - 1);
        trimmedDate = trimmedDate.substring(0, trimmedDate.length() - 1);
        try {
            intValue = Integer.parseInt(trimmedDate);
        }
        catch (NumberFormatException e) {
            throw new GenericQueryException("Invalid relative date : " + relativeDate);
        }
        return DateLiteralHelper.getRelativeDate(relativeDate, suffix, intValue);
    }

    private static ReadablePeriod getRelativeDate(String originalString, char suffix, int intValue) {
        switch (suffix) {
            case 'y': {
                return Years.years((int)intValue);
            }
            case 'M': {
                return Months.months((int)intValue);
            }
            case 'w': {
                return Weeks.weeks((int)intValue);
            }
            case 'd': {
                return Days.days((int)intValue);
            }
            case 'h': {
                return Hours.hours((int)intValue);
            }
            case 'm': {
                return Minutes.minutes((int)intValue);
            }
        }
        throw new IllegalArgumentException("Unrecognised relative date, must end in one of (y, M, w, d, h, m) : " + originalString);
    }

    static {
        SUPPORTED_DATE_FORMATS = ImmutableList.of((Object)DATE_DASH_PATTERN, (Object)DATE_SLASH_PATTERN, (Object)DATE_TIME_PATTERN, (Object)"yyyy/MM/dd HH:mm");
        DateTimeParser[] dateParsers = new DateTimeParser[]{DateTimeFormat.forPattern((String)DATE_DASH_PATTERN).getParser(), DateTimeFormat.forPattern((String)DATE_SLASH_PATTERN).getParser()};
        DateTimeParser[] dateTimeParsers = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm").getParser(), DateTimeFormat.forPattern((String)DATE_TIME_PATTERN).getParser()};
        dateFormatter = new DateTimeFormatterBuilder().append(null, dateParsers).toFormatter();
        dateTimeFormatter = new DateTimeFormatterBuilder().append(null, dateTimeParsers).toFormatter();
    }
}

