/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.fields;

import com.atlassian.fugue.Option;
import com.atlassian.querylang.fields.ValueType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class UISupport {
    private final ValueType valueType;
    private final String defaultOperator;
    private final String i18nKey;
    private final Optional<String> dataUri;
    private final Optional<String> tooltipI18nKey;

    private UISupport(Builder builder) {
        this.valueType = Objects.requireNonNull(builder.valueType);
        this.defaultOperator = Strings.isNullOrEmpty((String)builder.defaultOperator) ? (this.valueType.equals(ValueType.STRING_TYPE) ? "~" : "=") : builder.defaultOperator;
        this.dataUri = Optional.ofNullable(builder.dataUri);
        this.i18nKey = Objects.requireNonNull(builder.i18nKey);
        this.tooltipI18nKey = Optional.ofNullable(builder.tooltipI18nKey);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder copy() {
        return UISupport.builder().valueType(this.valueType).defaultOperator(this.defaultOperator).dataUri(this.dataUri.orElse(null)).i18nKey(this.i18nKey).tooltipI18nKey(this.tooltipI18nKey.orElse(null));
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public String getDefaultOperator() {
        return this.defaultOperator;
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    @Deprecated
    public Option<String> getTooltipI18nKey() {
        return Option.option(this.tooltipI18nKey.orElse(null));
    }

    public Optional<String> tooltipI18nKey() {
        return this.tooltipI18nKey;
    }

    @Deprecated
    public Option<String> getDataUri() {
        return Option.option(this.dataUri.orElse(null));
    }

    public Optional<String> dataUri() {
        return this.dataUri;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("valueType", (Object)this.valueType).add("defaultOperator", (Object)this.defaultOperator).add("i18nKey", (Object)this.i18nKey).add("dataUri", this.dataUri).add("tooltipI18nKey", this.tooltipI18nKey).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.valueType).append((Object)this.defaultOperator).append((Object)this.i18nKey).append(this.dataUri).append(this.tooltipI18nKey).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        UISupport rhs = (UISupport)obj;
        return new EqualsBuilder().append((Object)this.valueType, (Object)rhs.valueType).append((Object)this.defaultOperator, (Object)rhs.defaultOperator).append((Object)this.i18nKey, (Object)rhs.i18nKey).append(this.dataUri, rhs.dataUri).append(this.tooltipI18nKey, rhs.tooltipI18nKey).isEquals();
    }

    public static class Builder {
        private ValueType valueType;
        private String defaultOperator;
        private String dataUri;
        private String i18nKey;
        private String tooltipI18nKey;

        private Builder() {
        }

        public Builder valueType(ValueType vt) {
            this.valueType = vt;
            return this;
        }

        public Builder defaultOperator(String defaultOperator) {
            this.defaultOperator = defaultOperator;
            return this;
        }

        public Builder dataUri(@Nullable String dataUri) {
            this.dataUri = dataUri;
            return this;
        }

        public Builder i18nKey(String i18nKey) {
            this.i18nKey = i18nKey;
            return this;
        }

        public Builder tooltipI18nKey(@Nullable String tooltipI18nKey) {
            this.tooltipI18nKey = tooltipI18nKey;
            return this;
        }

        public Builder combine(Builder builder) {
            if (builder.valueType != null) {
                this.valueType = builder.valueType;
            }
            if (builder.defaultOperator != null) {
                this.defaultOperator = builder.defaultOperator;
            }
            if (builder.dataUri != null) {
                this.dataUri = builder.dataUri;
            }
            if (builder.i18nKey != null) {
                this.i18nKey = builder.i18nKey;
            }
            if (builder.tooltipI18nKey != null) {
                this.tooltipI18nKey = builder.tooltipI18nKey;
            }
            return this;
        }

        public UISupport build() {
            return new UISupport(this);
        }
    }
}

