/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.exceptions;

import com.atlassian.querylang.exceptions.QueryException;
import com.google.common.base.Joiner;

public class InvalidFunctionQueryException
extends QueryException {
    public InvalidFunctionQueryException(String msg) {
        super(msg);
    }

    public static InvalidFunctionQueryException invalidFunction(String function) {
        throw new InvalidFunctionQueryException(String.format("Unable to find query function '%s'", function));
    }

    public static InvalidFunctionQueryException invalidFunctionContext(String function, String ... contexts) {
        throw new InvalidFunctionQueryException(String.format("Unable to execute function '%s', the required contexts were not present : %s", function, Joiner.on((String)",").join((Object[])contexts)));
    }

    public static InvalidFunctionQueryException invalidSingleValueFunctionUsage(String function) {
        throw new InvalidFunctionQueryException(String.format("Unable to execute function '%s', expecting a function that returns multiple values", function));
    }

    public static InvalidFunctionQueryException invalidMultiValueFunctionUsage(String function) {
        throw new InvalidFunctionQueryException(String.format("Unable to execute function '%s', expecting a function that returns a single value", function));
    }
}

